"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.restApiKeySchema = exports.getRestApiKeyWithKibanaPrivilegesSchema = exports.crossClusterApiKeySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _authorization = require("../../authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Response of Kibana Create API key endpoint.
 */

/**
 * Represents the parameters for validating API Key credentials.
 */

/**
 * Represents the params for invalidating multiple API keys
 */

/**
 * The return value when invalidating an API key in Elasticsearch.
 */

const restApiKeySchema = exports.restApiKeySchema = _configSchema.schema.object({
  type: _configSchema.schema.maybe(_configSchema.schema.literal('rest')),
  name: _configSchema.schema.string(),
  expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
  role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({}, {
    unknowns: 'allow'
  }), {
    defaultValue: {}
  }),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const getRestApiKeyWithKibanaPrivilegesSchema = getBasePrivilegeNames => restApiKeySchema.extends({
  role_descriptors: null,
  kibana_role_descriptors: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    elasticsearch: _authorization.elasticsearchRoleSchema.extends({}, {
      unknowns: 'allow'
    }),
    kibana: (0, _authorization.getKibanaRoleSchema)(getBasePrivilegeNames)
  }))
});
exports.getRestApiKeyWithKibanaPrivilegesSchema = getRestApiKeyWithKibanaPrivilegesSchema;
const crossClusterApiKeySchema = exports.crossClusterApiKeySchema = restApiKeySchema.extends({
  type: _configSchema.schema.literal('cross_cluster'),
  role_descriptors: null,
  access: _configSchema.schema.object({
    search: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      query: _configSchema.schema.maybe(_configSchema.schema.any()),
      field_security: _configSchema.schema.maybe(_configSchema.schema.any()),
      allow_restricted_indices: _configSchema.schema.maybe(_configSchema.schema.boolean())
    }))),
    replication: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      names: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })))
  }, {
    unknowns: 'allow'
  })
});