"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChatParams = void 0;
var _constants = require("@kbn/stack-connectors-plugin/common/openai/constants");
var _language_models = require("@kbn/elastic-assistant-common/impl/language_models");
var _uuid = require("uuid");
var _constants2 = require("@kbn/stack-connectors-plugin/common/bedrock/constants");
var _constants3 = require("@kbn/elastic-assistant-common/impl/language_models/constants");
var _prompt = require("../../common/prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChatParams = async ({
  connectorId,
  model,
  prompt,
  citations
}, {
  actions,
  request,
  logger
}) => {
  const abortController = new AbortController();
  const abortSignal = abortController.signal;
  const actionsClient = await actions.getActionsClientWithRequest(request);
  const connector = await actionsClient.get({
    id: connectorId
  });
  let chatModel;
  let chatPrompt;
  switch (connector.actionTypeId) {
    case _constants.OPENAI_CONNECTOR_ID:
      chatModel = new _language_models.ActionsClientChatOpenAI({
        actions,
        logger,
        request,
        connectorId,
        model,
        traceId: (0, _uuid.v4)(),
        signal: abortSignal,
        temperature: (0, _constants3.getDefaultArguments)().temperature,
        // prevents the agent from retrying on failure
        // failure could be due to bad connector, we should deliver that result to the client asap
        maxRetries: 0
      });
      chatPrompt = (0, _prompt.Prompt)(prompt, {
        citations,
        context: true,
        type: 'openai'
      });
      break;
    case _constants2.BEDROCK_CONNECTOR_ID:
      const llmType = 'bedrock';
      chatModel = new _language_models.ActionsClientLlm({
        actions,
        logger,
        request,
        connectorId,
        model,
        traceId: (0, _uuid.v4)(),
        llmType,
        temperature: (0, _constants3.getDefaultArguments)(llmType).temperature
      });
      chatPrompt = (0, _prompt.Prompt)(prompt, {
        citations,
        context: true,
        type: 'anthropic'
      });
      break;
    default:
      break;
  }
  if (!chatModel || !chatPrompt) {
    throw new Error('Invalid connector id');
  }
  return {
    chatModel,
    chatPrompt,
    connector
  };
};
exports.getChatParams = getChatParams;