"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _retrievers = require("@langchain/core/retrievers");
var _documents = require("@langchain/core/documents");
var _get_value_for_selected_field = require("../utils/get_value_for_selected_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ElasticsearchRetriever extends _retrievers.BaseRetriever {
  static lc_name() {
    return 'ElasticsearchRetriever';
  }
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "lc_namespace", ['langchain', 'retrievers', 'elasticsearch']);
    (0, _defineProperty2.default)(this, "query_body_fn", void 0);
    (0, _defineProperty2.default)(this, "index", void 0);
    (0, _defineProperty2.default)(this, "content_field", void 0);
    (0, _defineProperty2.default)(this, "hit_doc_mapper", void 0);
    (0, _defineProperty2.default)(this, "k", void 0);
    (0, _defineProperty2.default)(this, "client", void 0);
    this.content_field = params.content_field;
    this.query_body_fn = params.retriever;
    this.content_field = params.content_field;
    this.index = params.index;
    this.k = params.k;
    this.client = params.client;
  }
  async _getRelevantDocuments(query) {
    try {
      const queryBody = this.query_body_fn(query);
      const results = await this.client.transport.request({
        method: 'POST',
        path: `/${this.index}/_search`,
        body: {
          ...queryBody,
          size: this.k
        }
      });
      const hits = results.hits.hits;

      // default elasticsearch doc to LangChain doc
      let mapper = hit => {
        const pageContentFieldKey = typeof this.content_field === 'string' ? this.content_field : this.content_field[hit._index];

        // we need to iterate over the _source object to get the value of complex key definition such as metadata.source
        const valueForSelectedField = (0, _get_value_for_selected_field.getValueForSelectedField)(hit._source, pageContentFieldKey);
        return new _documents.Document({
          pageContent: valueForSelectedField,
          metadata: {
            _score: hit._score,
            _id: hit._id,
            _index: hit._index
          }
        });
      };
      if (this.hit_doc_mapper) {
        mapper = this.hit_doc_mapper;
      }
      const documents = hits.map(mapper);
      return documents;
    } catch (error) {
      throw error;
    }
  }
}
exports.ElasticsearchRetriever = ElasticsearchRetriever;