"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFromChatMessages = void 0;
var _types = require("../types");
var _transform_annotation_to_doc = require("./transform_annotation_to_doc");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFromChatMessages = messages => messages.map(({
  id,
  content,
  createdAt,
  role,
  annotations = []
}) => {
  const commonMessageProp = {
    id,
    content,
    createdAt,
    role
  };
  if (role === _types.MessageRole.assistant) {
    var _annotations$find, _annotations$find$doc, _annotations$find2, _annotations$find2$do, _annotations$find3, _annotations$find4;
    return {
      ...commonMessageProp,
      citations: (_annotations$find = annotations.find(annotation => annotation.type === 'citations')) === null || _annotations$find === void 0 ? void 0 : (_annotations$find$doc = _annotations$find.documents) === null || _annotations$find$doc === void 0 ? void 0 : _annotations$find$doc.map(_transform_annotation_to_doc.transformAnnotationToDoc),
      retrievalDocs: (_annotations$find2 = annotations.find(annotation => annotation.type === 'retrieved_docs')) === null || _annotations$find2 === void 0 ? void 0 : (_annotations$find2$do = _annotations$find2.documents) === null || _annotations$find2$do === void 0 ? void 0 : _annotations$find2$do.map(_transform_annotation_to_doc.transformAnnotationToDoc),
      inputTokens: {
        context: annotations === null || annotations === void 0 ? void 0 : (_annotations$find3 = annotations.find(annotation => annotation.type === 'context_token_count')) === null || _annotations$find3 === void 0 ? void 0 : _annotations$find3.count,
        total: annotations === null || annotations === void 0 ? void 0 : (_annotations$find4 = annotations.find(annotation => annotation.type === 'prompt_token_count')) === null || _annotations$find4 === void 0 ? void 0 : _annotations$find4.count
      }
    };
  }
  return commonMessageProp;
});
exports.transformFromChatMessages = transformFromChatMessages;