"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceIndicesFields = exports.getIndicesWithNoSourceFields = void 0;
var _reactQuery = require("@tanstack/react-query");
var _reactHookForm = require("react-hook-form");
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
var _create_query = require("../utils/create_query");
var _use_usage_tracker = require("./use_usage_tracker");
var _constants = require("../analytics/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndicesWithNoSourceFields = defaultSourceFields => {
  const indices = [];
  Object.keys(defaultSourceFields).forEach(index => {
    if (defaultSourceFields[index].length === 0) {
      indices.push(index);
    }
  });
  return indices.length === 0 ? undefined : indices.join();
};
exports.getIndicesWithNoSourceFields = getIndicesWithNoSourceFields;
const useSourceIndicesFields = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [noFieldsIndicesWarning, setNoFieldsIndicesWarning] = (0, _react.useState)(null);
  const {
    resetField
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      value: selectedIndices,
      onChange: onIndicesChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.indices
  });
  const {
    field: {
      onChange: onElasticsearchQueryChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.elasticsearchQuery,
    defaultValue: {}
  });
  const {
    field: {
      onChange: onSourceFieldsChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.sourceFields
  });
  const {
    data: fields
  } = (0, _reactQuery.useQuery)({
    enabled: selectedIndices.length > 0,
    queryKey: ['fields', selectedIndices.toString()],
    queryFn: async () => {
      const response = await services.http.post(_types.APIRoutes.POST_QUERY_SOURCE_FIELDS, {
        body: JSON.stringify({
          indices: selectedIndices
        })
      });
      return response;
    }
  });
  (0, _react.useEffect)(() => {
    if (fields) {
      var _Object$values, _Object$values$flat;
      resetField(_types.ChatFormFields.queryFields);
      const defaultFields = (0, _create_query.getDefaultQueryFields)(fields);
      const defaultSourceFields = (0, _create_query.getDefaultSourceFields)(fields);
      const indicesWithNoSourceFields = getIndicesWithNoSourceFields(defaultSourceFields);
      if (indicesWithNoSourceFields) {
        setNoFieldsIndicesWarning(indicesWithNoSourceFields);
      } else {
        setNoFieldsIndicesWarning(null);
      }
      onElasticsearchQueryChange((0, _create_query.createQuery)(defaultFields, fields));
      onSourceFieldsChange(defaultSourceFields);
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceFieldsLoaded, (_Object$values = Object.values(fields)) === null || _Object$values === void 0 ? void 0 : (_Object$values$flat = _Object$values.flat()) === null || _Object$values$flat === void 0 ? void 0 : _Object$values$flat.length);
    } else {
      setNoFieldsIndicesWarning(null);
    }
    setLoading(false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fields]);
  const addIndex = newIndex => {
    const newIndices = [...selectedIndices, newIndex];
    setLoading(true);
    onIndicesChange(newIndices);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceIndexUpdated, newIndices.length);
  };
  const removeIndex = index => {
    const newIndices = selectedIndices.filter(indexName => indexName !== index);
    setLoading(true);
    onIndicesChange(newIndices);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.sourceIndexUpdated, newIndices.length);
  };
  return {
    indices: selectedIndices,
    fields,
    loading,
    addIndex,
    removeIndex,
    noFieldsIndicesWarning
  };
};
exports.useSourceIndicesFields = useSourceIndicesFields;