"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConnectors = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = ['search-playground, load-connectors'];
const connectorTypeToLLM = [{
  actionId: _common.OPENAI_CONNECTOR_ID,
  actionProvider: _common.OpenAiProviderType.AzureAi,
  match: connector => connector.actionTypeId === _common.OPENAI_CONNECTOR_ID && connector.config.apiProvider === _common.OpenAiProviderType.AzureAi,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIAzureConnectorTitle', {
      defaultMessage: 'OpenAI Azure'
    }),
    type: _types.LLMs.openai_azure
  })
}, {
  actionId: _common.OPENAI_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.OPENAI_CONNECTOR_ID && connector.config.apiProvider === _common.OpenAiProviderType.OpenAi,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.openAIConnectorTitle', {
      defaultMessage: 'OpenAI'
    }),
    type: _types.LLMs.openai
  })
}, {
  actionId: _common.BEDROCK_CONNECTOR_ID,
  match: connector => connector.actionTypeId === _common.BEDROCK_CONNECTOR_ID,
  transform: connector => ({
    ...connector,
    title: _i18n.i18n.translate('xpack.searchPlayground.bedrockConnectorTitle', {
      defaultMessage: 'Bedrock'
    }),
    type: _types.LLMs.bedrock
  })
}];
const useLoadConnectors = () => {
  const {
    services: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)(QUERY_KEY, async () => {
    const queryResult = await (0, _constants.loadAllActions)({
      http
    });
    return queryResult.reduce((result, connector) => {
      const {
        transform
      } = connectorTypeToLLM.find(({
        match
      }) => match(connector)) || {};
      if (!connector.isMissingSecrets && !!transform) {
        return [...result, transform(connector)];
      }
      return result;
    }, []);
  }, {
    retry: false,
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        var _notifications$toasts;
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: _i18n.i18n.translate('xpack.searchPlayground.loadConnectorsError', {
            defaultMessage: 'Error loading connectors. Please check your configuration and try again.'
          })
        });
      }
    }
  });
};
exports.useLoadConnectors = useLoadConnectors;