"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewQueryFlyout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../../analytics/constants");
var _doc_links = require("../../../common/doc_links");
var _use_indices_fields = require("../../hooks/use_indices_fields");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _create_query = require("../../utils/create_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupTypeQueryFields = (fields, queryFields) => Object.entries(queryFields).map(([index, selectedFields]) => {
  const indexFields = fields[index];
  let typeQueryFields = '';
  if (selectedFields.some(field => indexFields.bm25_query_fields.includes(field))) {
    typeQueryFields = 'BM25';
  }
  if (selectedFields.some(field => indexFields.dense_vector_query_fields.find(vectorField => vectorField.field === field))) {
    typeQueryFields += (typeQueryFields ? '_' : '') + 'DENSE';
  }
  if (selectedFields.some(field => indexFields.elser_query_fields.find(elserField => elserField.field === field))) {
    typeQueryFields += (typeQueryFields ? '_' : '') + 'SPARSE';
  }
  return typeQueryFields;
});
const ViewQueryFlyout = ({
  onClose
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const selectedIndices = getValues(_types.ChatFormFields.indices);
  const {
    fields
  } = (0, _use_indices_fields.useIndicesFields)(selectedIndices);
  const defaultFields = (0, _create_query.getDefaultQueryFields)(fields);
  const {
    field: {
      onChange: queryFieldsOnChange,
      value: queryFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.queryFields,
    defaultValue: defaultFields
  });
  const [tempQueryFields, setTempQueryFields] = (0, _react.useState)(queryFields);
  const {
    field: {
      onChange: elasticsearchQueryChange
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.elasticsearchQuery
  });
  const isQueryFieldSelected = (index, field) => {
    return tempQueryFields[index].includes(field);
  };
  const updateFields = (index, options) => {
    const newFields = options.filter(option => option.checked === 'on').map(option => option.label);
    setTempQueryFields({
      ...tempQueryFields,
      [index]: newFields
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.viewQueryFieldsUpdated, newFields.length);
  };
  const saveQuery = () => {
    queryFieldsOnChange(tempQueryFields);
    elasticsearchQueryChange((0, _create_query.createQuery)(tempQueryFields, fields));
    onClose();
    const groupedQueryFields = groupTypeQueryFields(fields, tempQueryFields);
    groupedQueryFields.forEach(typeQueryFields => usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.viewQuerySaved}_${typeQueryFields}`));
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.viewQueryFlyoutOpened);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.title",
    defaultMessage: "Customize your Elasticsearch query"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.description",
    defaultMessage: "This query will be used to search your indices. Customize by choosing which fields in your Elasticsearch documents to search."
  }), ` `, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.retrievalOptimize,
    target: "_blank",
    "data-test-subj": "query-optimize-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.learnMoreQueryOptimizeLink",
    defaultMessage: "Learn more."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "m",
    paddingSize: "m",
    lineNumbers: true,
    "data-test-subj": "ViewElasticsearchQueryResult"
  }, JSON.stringify((0, _create_query.createQuery)(tempQueryFields, fields), null, 2))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.table.title",
    defaultMessage: "Fields to search (per index)"
  }))), Object.entries(fields).map(([index, group]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: index,
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, index))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": "Select query fields",
    "data-test-subj": `queryFieldsSelectable_${index}`,
    options: [...group.elser_query_fields, ...group.dense_vector_query_fields, ...group.bm25_query_fields].map((field, idx) => {
      const checked = isQueryFieldSelected(index, typeof field === 'string' ? field : field.field);
      return {
        label: typeof field === 'string' ? field : field.field,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
          id: `checkbox_${idx}`,
          checked: checked,
          onChange: () => {}
        }),
        checked: checked ? 'on' : undefined
      };
    }),
    listProps: {
      bordered: false,
      showIcons: false
    },
    onChange: newOptions => updateFields(index, newOptions)
  }, list => list), group.skipped_fields > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": `skipped_fields_${index}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "eyeClosed"
  }), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.hiddenFields",
    defaultMessage: "{skippedFields} fields are hidden.",
    values: {
      skippedFields: group.skipped_fields
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.hiddenFields,
    target: "_blank",
    "data-test-subj": "hidden-fields-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.learnMoreLink",
    defaultMessage: "Learn more."
  }))))))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: saveQuery,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.saveButton",
    defaultMessage: "Save changes"
  }))))));
};
exports.ViewQueryFlyout = ViewQueryFlyout;