"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewCodeFlyout = exports.ES_CLIENT_DETAILS = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../../analytics/constants");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _use_kibana = require("../../hooks/use_kibana");
var _routes = require("../../../common/routes");
var _py_langchain_python = require("./examples/py_langchain_python");
var _py_lang_client = require("./examples/py_lang_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ES_CLIENT_DETAILS = cloud => {
  if (cloud) {
    return `
es_client = Elasticsearch(
    "${cloud.elasticsearchUrl}",
    api_key=os.environ["ES_API_KEY"]
)
      `;
  }
  return `
es_client = Elasticsearch(
    "<your-elasticsearch-url>"
)
  `;
};
exports.ES_CLIENT_DETAILS = ES_CLIENT_DETAILS;
const ViewCodeFlyout = ({
  onClose
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)('py-es-client');
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const formValues = getValues();
  const {
    services: {
      cloud,
      http
    }
  } = (0, _use_kibana.useKibana)();
  const CLIENT_STEP = ES_CLIENT_DETAILS(cloud);
  const steps = {
    'lc-py': (0, _py_langchain_python.LANGCHAIN_PYTHON)(formValues, CLIENT_STEP),
    'py-es-client': (0, _py_lang_client.PY_LANG_CLIENT)(formValues, CLIENT_STEP)
  };
  const handleLanguageChange = e => {
    setSelectedLanguage(e.target.value);
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.viewCodeFlyoutOpened);
  }, [usageTracker]);
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(`${_constants.AnalyticsEvents.viewCodeLanguageChange}_${selectedLanguage}`);
  }, [usageTracker, selectedLanguage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.title",
    defaultMessage: "Application code"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.subtitle",
    defaultMessage: "Here's the code used to render this search experience. You can integrate it into your own application, modifying as needed."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [{
      value: 'py-es-client',
      text: 'Python Elasticsearch Client with OpenAI'
    }, {
      value: 'lc-py',
      text: 'LangChain Python with OpenAI'
    }],
    onChange: handleLanguageChange,
    value: selectedLanguage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "popout",
    href: http.basePath.prepend(_routes.MANAGEMENT_API_KEYS),
    "data-test-subj": "viewCodeManageApiKeys",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.flyout.apiKeysAction",
    defaultMessage: "Manage API Keys"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, steps[selectedLanguage]))));
};
exports.ViewCodeFlyout = ViewCodeFlyout;