"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartChatPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StartChatPanel = ({
  title,
  description,
  children,
  isValid,
  dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true,
  paddingSize: "l",
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h5", null, title)), isValid && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "check",
  color: "success"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "success"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.searchPlayground.startChatPanel.verified",
  defaultMessage: "Completed"
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "l"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, description)), children));
exports.StartChatPanel = StartChatPanel;