"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesPanelSidebar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _add_indices_field = require("./add_indices_field");
var _indices_list = require("./indices_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesPanelSidebar = () => {
  const {
    indices: selectedIndices,
    removeIndex,
    addIndex,
    loading
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.searchPlayground.sources.callout', {
      defaultMessage: 'Changes update the query used to search your data'
    }),
    iconType: "warning",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_indices_list.IndicesList, {
    indices: selectedIndices,
    onRemoveClick: removeIndex,
    hasBorder: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_indices_field.AddIndicesField, {
    selectedIndices: selectedIndices,
    onIndexSelect: addIndex,
    loading: loading
  })));
};
exports.SourcesPanelSidebar = SourcesPanelSidebar;