"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesPanelForStartChat = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _add_indices_field = require("./add_indices_field");
var _indices_table = require("./indices_table");
var _start_chat_panel = require("../start_chat_panel");
var _create_index_callout = require("./create_index_callout");
var _use_query_indices = require("../../hooks/use_query_indices");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesPanelForStartChat = () => {
  const {
    indices: selectedIndices,
    removeIndex,
    addIndex,
    loading: fieldIndicesLoading,
    noFieldsIndicesWarning
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const {
    indices,
    isLoading
  } = (0, _use_query_indices.useQueryIndices)();
  return /*#__PURE__*/_react.default.createElement(_start_chat_panel.StartChatPanel, {
    title: _i18n.i18n.translate('xpack.searchPlayground.emptyPrompts.sources.title', {
      defaultMessage: 'Select indices'
    }),
    description: _i18n.i18n.translate('xpack.searchPlayground.emptyPrompts.sources.description', {
      defaultMessage: "Select the Elasticsearch indices you'd like to query, providing additional context for the LLM."
    }),
    isValid: !!(selectedIndices !== null && selectedIndices !== void 0 && selectedIndices.length),
    dataTestSubj: "selectIndicesChatPanel"
  }, !!(selectedIndices !== null && selectedIndices !== void 0 && selectedIndices.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_indices_table.IndicesTable, {
    indices: selectedIndices,
    onRemoveClick: removeIndex
  })), noFieldsIndicesWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    "data-test-subj": "NoIndicesFieldsMessage"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchPlayground.emptyPrompts.sources.warningCallout', {
    defaultMessage: 'No fields found for {errorMessage}. Try adding data to these indices.',
    values: {
      errorMessage: noFieldsIndicesWarning
    }
  }))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "indicesLoading"
  })), !isLoading && !!(indices !== null && indices !== void 0 && indices.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_indices_field.AddIndicesField, {
    selectedIndices: selectedIndices,
    onIndexSelect: addIndex,
    loading: fieldIndicesLoading
  })), !isLoading && !(indices !== null && indices !== void 0 && indices.length) && /*#__PURE__*/_react.default.createElement(_create_index_callout.CreateIndexCallout, null));
};
exports.SourcesPanelForStartChat = SourcesPanelForStartChat;