"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesTable = ({
  indices,
  onRemoveClick
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
  items: indices.map(index => ({
    index
  })),
  columns: [{
    field: 'index',
    name: _i18n.i18n.translate('xpack.searchPlayground.sources.indices.table.label', {
      defaultMessage: 'Selected indices'
    }),
    truncateText: true,
    render: index => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "#"
    }, index)
  }, {
    actions: [{
      type: 'icon',
      name: _i18n.i18n.translate('xpack.searchPlayground.sources.indices.table.remove.label', {
        defaultMessage: 'Remove'
      }),
      description: _i18n.i18n.translate('xpack.searchPlayground.sources.indices.table.remove.description', {
        defaultMessage: 'Remove index'
      }),
      icon: 'minusInCircle',
      onClick: item => onRemoveClick(item.index),
      'data-test-subj': `removeIndexButton`
    }]
  }],
  hasActions: true
});
exports.IndicesTable = IndicesTable;