"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicesList = ({
  indices,
  onRemoveClick,
  hasBorder
}) => indices !== null && indices !== void 0 && indices.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  fullWidth: true,
  label: _i18n.i18n.translate('xpack.searchPlayground.sources.indices.label', {
    defaultMessage: 'Selected indices'
  }),
  labelType: "legend"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
  bordered: hasBorder,
  maxWidth: false,
  wrapText: true
}, indices.map(index => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
  key: index,
  wrapText: true,
  color: "primary",
  label: index,
  size: "s",
  extraAction: {
    alwaysShow: true,
    'aria-label': _i18n.i18n.translate('xpack.searchPlayground.sources.indices.removeIndex', {
      defaultMessage: 'Remove index from sources'
    }),
    color: 'text',
    iconType: 'minusInCircle',
    onClick: () => onRemoveClick(index),
    disabled: indices.length === 1,
    'data-test-subj': `removeIndexButton`
  }
})))) : null;
exports.IndicesList = IndicesList;