"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _doc_links = require("../../../common/doc_links");
var _retrieval_docs_flyout = require("./retrieval_docs_flyout");
var _copy_action_button = require("./copy_action_button");
var _citations_table = require("./citations_table");
var _token_estimate_tooltip = require("./token_estimate_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AIMessageCSS = (0, _react2.css)`
  white-space: break-spaces;
`;
const AssistantMessage = ({
  message
}) => {
  const [isDocsFlyoutOpen, setIsDocsFlyoutOpen] = (0, _react.useState)(false);
  const {
    content,
    createdAt,
    citations,
    retrievalDocs,
    inputTokens
  } = message;
  const username = _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.username', {
    defaultMessage: 'AI'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!(retrievalDocs !== null && retrievalDocs !== void 0 && retrievalDocs.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: username,
    timelineAvatar: "dot",
    "data-test-subj": "retrieval-docs-comment",
    event: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.assistant.retrievalDocs",
      defaultMessage: "Grounding answer based on"
    }), ` `)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      css: {
        blockSize: 'auto'
      },
      size: "s",
      flush: "left",
      "data-test-subj": "retrieval-docs-button",
      onClick: () => setIsDocsFlyoutOpen(true)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.assistant.retrievalDocButton",
      defaultMessage: "{count} document sources",
      values: {
        count: retrievalDocs.length
      }
    })), isDocsFlyoutOpen && /*#__PURE__*/_react.default.createElement(_retrieval_docs_flyout.RetrievalDocsFlyout, {
      onClose: () => setIsDocsFlyoutOpen(false),
      retrievalDocs: retrievalDocs
    }))
  }), (retrievalDocs === null || retrievalDocs === void 0 ? void 0 : retrievalDocs.length) === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: username,
    timelineAvatar: "dot",
    "data-test-subj": "retrieval-docs-comment-no-docs",
    event: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.assistant.noRetrievalDocs",
      defaultMessage: "Unable to retrieve documents based on the provided question and query."
    }), ` `)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _doc_links.docLinks.retrievalOptimize,
      target: "_blank",
      "data-test-subj": "retrieval-optimization-documentation-link"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.assistant.noRetrievalDocs.learnMore",
      defaultMessage: " Learn more."
    })), isDocsFlyoutOpen && /*#__PURE__*/_react.default.createElement(_retrieval_docs_flyout.RetrievalDocsFlyout, {
      onClose: () => setIsDocsFlyoutOpen(false),
      retrievalDocs: retrievalDocs
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: username,
    event: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.event.responded', {
      defaultMessage: 'responded'
    }),
    "data-test-subj": "assistant-message",
    timestamp: createdAt && _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.createdAt', {
      defaultMessage: 'at {time}',
      values: {
        time: (0, _moment.default)(createdAt).format('HH:mm')
      }
    }),
    timelineAvatar: "compute",
    timelineAvatarAriaLabel: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.avatarAriaLabel', {
      defaultMessage: 'AI'
    }),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_token_estimate_tooltip.TokenEstimateTooltip, {
      context: inputTokens.context,
      total: inputTokens.total
    }), /*#__PURE__*/_react.default.createElement(_copy_action_button.CopyActionButton, {
      copyText: String(content),
      ariaLabel: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.copyLabel', {
        defaultMessage: 'Copy assistant message'
      })
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.chat.message.assistant.title",
    defaultMessage: "Summary"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: AIMessageCSS
  }, /*#__PURE__*/_react.default.createElement("p", null, content)), !!(citations !== null && citations !== void 0 && citations.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "assistant-message-citations"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.chat.message.assistant.citations.title",
    defaultMessage: "Citations"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_citations_table.CitationsTable, {
    citations: citations
  }))));
};
exports.AssistantMessage = AssistantMessage;