"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditContextFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../common/doc_links");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _use_indices_fields = require("../../hooks/use_indices_fields");
var _create_query = require("../../utils/create_query");
var _constants = require("../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditContextFlyout = ({
  onClose
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const selectedIndices = getValues(_types.ChatFormFields.indices);
  const {
    fields
  } = (0, _use_indices_fields.useIndicesFields)(selectedIndices);
  const defaultFields = (0, _create_query.getDefaultSourceFields)(fields);
  const {
    field: {
      onChange: onChangeSize,
      value: docSizeInitialValue
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.docSize
  });
  const [docSize, setDocSize] = (0, _react.useState)(docSizeInitialValue);
  const {
    field: {
      onChange: onChangeSourceFields,
      value: sourceFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.ChatFormFields.sourceFields,
    defaultValue: defaultFields
  });
  const [tempSourceFields, setTempSourceFields] = (0, _react.useState)(sourceFields);
  const updateSourceField = (index, field) => {
    setTempSourceFields({
      ...tempSourceFields,
      [index]: [field]
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextFieldToggled);
  };
  const saveSourceFields = () => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextSaved);
    onChangeSourceFields(tempSourceFields);
    onChangeSize(docSize);
    onClose();
  };
  const handleDocSizeChange = e => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextDocSizeChanged);
    setDocSize(Number(e.target.value));
  };
  (0, _react.useEffect)(() => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.load(_constants.AnalyticsEvents.editContextFlyoutOpened);
  }, [usageTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.title",
    defaultMessage: "Edit context"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.description",
    defaultMessage: "Context is the information you provide to the LLM, by selecting fields from your Elasticsearch documents. Optimize context for better results."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.context,
    target: "_blank",
    "data-test-subj": "context-optimization-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.learnMoreLink",
    defaultMessage: " Learn more."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchPlayground.editContext.flyout.docsRetrievedCount', {
      defaultMessage: 'Number of documents sent to LLM'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [{
      value: 1,
      text: '1'
    }, {
      value: 3,
      text: '3'
    }, {
      value: 5,
      text: '5'
    }, {
      value: 10,
      text: '10'
    }],
    value: docSize,
    onChange: handleDocSizeChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.table.title",
    defaultMessage: "Select fields"
  })))), Object.entries(fields).map(([index, group]) => {
    var _tempSourceFields$ind;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      "data-test-subj": `contextFieldsSelectable_${index}`,
      options: group.source_fields.map(field => ({
        value: field,
        inputDisplay: field
      })),
      valueOfSelected: (_tempSourceFields$ind = tempSourceFields[index]) === null || _tempSourceFields$ind === void 0 ? void 0 : _tempSourceFields$ind[0],
      onChange: value => updateSourceField(index, value)
    })));
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: saveSourceFields,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.flyout.saveButton",
    defaultMessage: "Save changes"
  }))))));
};
exports.EditContextFlyout = EditContextFlyout;