"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatSidebar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sources_panel_sidebar = require("./sources_panel/sources_panel_sidebar");
var _summarization_panel = require("./summarization_panel/summarization_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatSidebar = ({
  selectedIndicesCount
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordions = [{
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'summarizationAccordion'
    }),
    title: _i18n.i18n.translate('xpack.searchPlayground.sidebar.summarizationTitle', {
      defaultMessage: 'Model settings'
    }),
    children: /*#__PURE__*/_react.default.createElement(_summarization_panel.SummarizationPanel, null)
  }, {
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'sourcesAccordion'
    }),
    title: _i18n.i18n.translate('xpack.searchPlayground.sidebar.sourceTitle', {
      defaultMessage: 'Indices'
    }),
    extraAction: !!selectedIndicesCount && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchPlayground.sidebar.sourceIndicesCount', {
      defaultMessage: '{count, number} {count, plural, one {Index} other {Indices}}',
      values: {
        count: Number(selectedIndicesCount)
      }
    }))),
    children: /*#__PURE__*/_react.default.createElement(_sources_panel_sidebar.SourcesPanelSidebar, null)
  }];
  const [openAccordionId, setOpenAccordionId] = (0, _react.useState)(accordions[0].id);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "eui-yScroll",
    gutterSize: "none"
  }, accordions.map(({
    id,
    title,
    extraAction,
    children
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: id,
    css: {
      borderBottom: index === accordions.length - 1 ? 'none' : euiTheme.border.thin,
      padding: `0 ${euiTheme.size.l}`,
      flexGrow: openAccordionId === id ? 1 : 0,
      transition: `${euiTheme.animation.normal} ease-in-out`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, title)),
    extraAction: extraAction,
    buttonProps: {
      paddingSize: 'l'
    },
    forceState: openAccordionId === id ? 'open' : 'closed',
    onToggle: () => setOpenAccordionId(openAccordionId === id ? '' : id)
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })))));
};
exports.ChatSidebar = ChatSidebar;