"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatPlaygroundOverview = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _playground_provider = require("./providers/playground_provider");
var _app = require("./components/app");
var _embeddable = require("./embeddable");
var _playground_header_docs = require("./components/playground_header_docs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChatPlaygroundOverview = () => {
  return /*#__PURE__*/_react.default.createElement(_playground_provider.PlaygroundProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "svlPlaygroundPage",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "chat-playground-home-page-title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.pageTitle",
      defaultMessage: "Playground"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.searchPlayground.pageTitle.techPreview', {
        defaultMessage: 'TECH PREVIEW'
      }),
      color: "hollow"
    }))),
    "data-test-subj": "chat-playground-home-page",
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_playground_header_docs.PlaygroundHeaderDocs, null), /*#__PURE__*/_react.default.createElement(_embeddable.PlaygroundToolbar, null)]
  }), /*#__PURE__*/_react.default.createElement(_app.App, null)));
};
exports.ChatPlaygroundOverview = ChatPlaygroundOverview;