"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
var _notebook_catalog = require("../lib/notebook_catalog");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(router, logger) {
  router.get({
    path: '/internal/search_notebooks/notebooks',
    validate: {}
  }, async (_context, _request, response) => {
    return response.ok({
      body: _notebook_catalog.DEFAULT_NOTEBOOKS,
      headers: {
        'content-type': 'application/json'
      }
    });
  });
  router.get({
    path: '/internal/search_notebooks/notebooks/{notebookId}',
    validate: {
      params: _configSchema.schema.object({
        notebookId: _configSchema.schema.string()
      })
    }
  }, async (_, request, response) => {
    const notebookId = request.params.notebookId;
    if (notebookId === _constants.INTRODUCTION_NOTEBOOK.id) {
      return response.ok({
        body: _constants.INTRODUCTION_NOTEBOOK,
        headers: {
          'content-type': 'application/json'
        }
      });
    }
    if (!_notebook_catalog.NOTEBOOKS_MAP.hasOwnProperty(notebookId)) {
      logger.warn(`Unknown search notebook requested ${notebookId}`);
      return response.notFound();
    }
    const notebookMetadata = _notebook_catalog.NOTEBOOKS_MAP[notebookId];
    let notebook;
    try {
      notebook = await (0, _notebook_catalog.getNotebook)(notebookId, {
        logger
      });
    } catch (e) {
      return response.customError(e.message);
    }
    return response.ok({
      body: {
        ...notebookMetadata,
        notebook
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  });
}