"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNotebook = exports.NOTEBOOKS_MAP = exports.DEFAULT_NOTEBOOKS = void 0;
var _promises = _interopRequireDefault(require("fs/promises"));
var _path = _interopRequireDefault(require("path"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NOTEBOOKS_DATA_DIR = '../data';
const DEFAULT_NOTEBOOKS = exports.DEFAULT_NOTEBOOKS = {
  notebooks: [{
    id: '00_quick_start',
    title: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.quickStart.title', {
      defaultMessage: 'Semantic search quick start'
    }),
    description: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.quickStart.description', {
      defaultMessage: 'Learn how to create a simple hybrid search system that combines semantic search and lexical (keyword) search.'
    })
  }, {
    id: '01_keyword_querying_filtering',
    title: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.keywordQueryFiltering.title', {
      defaultMessage: 'Keyword querying and filtering'
    }),
    description: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.keywordQueryFiltering.description', {
      defaultMessage: 'Learn the basics of Elasticsearch queries and filters.'
    })
  }, {
    id: '02_hybrid_search',
    title: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.hybridSearch.title', {
      defaultMessage: 'Hybrid Search using RRF'
    }),
    description: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.hybridSearch.description', {
      defaultMessage: 'Learn how to use the reciprocal rank fusion algorithm to combine the results of BM25 and kNN semantic search.'
    })
  }, {
    id: '03_elser',
    title: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.elser.title', {
      defaultMessage: 'Semantic Search using ELSER v2 text expansion'
    }),
    description: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.elser.description', {
      defaultMessage: "Learn how to use ELSER, Elastic's retrieval model for text expansion-powered semantic search that works out of the box."
    })
  }, {
    id: '04_multilingual',
    title: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.multilingual.title', {
      defaultMessage: 'Multilingual semantic search'
    }),
    description: _i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.multilingual.description', {
      defaultMessage: 'Learn how to use a multilingual embedding model to search over a dataset of mixed language documents.'
    })
  }]
};
const NOTEBOOKS_MAP = exports.NOTEBOOKS_MAP = DEFAULT_NOTEBOOKS.notebooks.reduce((nbMap, nb) => {
  nbMap[nb.id] = nb;
  return nbMap;
}, {});
const NOTEBOOK_IDS = DEFAULT_NOTEBOOKS.notebooks.map(({
  id
}) => id);
const getNotebook = async (notebookId, {
  logger
}) => {
  // Only server pre-defined notebooks, since we're reading files from disk only allow IDs
  // for the known notebooks so that we aren't attempting to read any file from disk given user input
  if (!NOTEBOOK_IDS.includes(notebookId)) {
    logger.warn(`Unknown search notebook requested ${notebookId}`);
    throw new Error(_i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.errors.unknownId', {
      defaultMessage: 'Unknown Notebook ID'
    }));
  }
  const notebookPath = _path.default.join(__dirname, NOTEBOOKS_DATA_DIR, `${notebookId}.json`);
  try {
    await _promises.default.access(notebookPath, _promises.default.constants.F_OK);
    const notebook = (await (specifier => new Promise(r => r(`${specifier}`)).then(s => _interopRequireWildcard(require(s))))(notebookPath)).default;
    return notebook;
  } catch (err) {
    logger.error(`Error reading search notebook ${notebookId}`, err);
    throw new Error(_i18n.i18n.translate('xpack.searchNotebooks.notebooksCatalog.errors.notebookImportFailure', {
      defaultMessage: 'Failed to fetch notebook.'
    }));
  }
};
exports.getNotebook = getNotebook;