"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNotebook = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ipynb = require("@kbn/ipynb");
var _i18nReact = require("@kbn/i18n-react");
var _use_notebook = require("../hooks/use_notebook");
var _loading_panel = require("./loading_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchNotebook = ({
  notebookId
}) => {
  const {
    data,
    isLoading,
    error
  } = (0, _use_notebook.useNotebook)(notebookId);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, null);
  }
  if (!data || error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchNotebooks.notebook.fetchError.title",
        defaultMessage: "Error loading notebook"
      })),
      titleSize: "l",
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchNotebooks.notebook.fetchError.body",
        defaultMessage: "We can't fetch the notebook from Kibana due to the following error:"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        css: {
          textAlign: 'left'
        }
      }, JSON.stringify(error)))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xl",
    hasShadow: false,
    style: {
      display: 'flex',
      justifyContent: 'center'
    },
    "data-test-subj": `console-embedded-notebook-view-panel-${notebookId}`
  }, /*#__PURE__*/_react.default.createElement(_ipynb.NotebookRenderer, {
    notebook: data.notebook
  }));
};
exports.SearchNotebook = SearchNotebook;