"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _result_field = require("./result_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ResultFields = ({
  fields,
  isExpanded
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, fields.map(field => /*#__PURE__*/_react.default.createElement(_result_field.ResultField, {
    isExpanded: isExpanded,
    iconType: field.iconType,
    fieldName: field.fieldName,
    fieldValue: field.fieldValue,
    fieldType: field.fieldType,
    key: field.fieldName
  }))));
};
exports.ResultFields = ResultFields;