"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.durationToText = durationToText;
exports.getSyncJobDuration = getSyncJobDuration;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSyncJobDuration(syncJob) {
  return syncJob.started_at ? _moment.default.duration((0, _moment.default)(syncJob.completed_at || new Date()).diff((0, _moment.default)(syncJob.started_at))) : undefined;
}
function durationToText(input) {
  if (input) {
    const days = input.days();
    const hours = input.hours();
    const minutes = input.minutes();
    const seconds = input.seconds();
    return `${hours + days * 24}h ${minutes}m ${seconds}s`;
  } else {
    return '--';
  }
}