"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerMethod = exports.SyncStatus = exports.SyncJobType = exports.FilteringValidationState = exports.FilteringRuleRuleValues = exports.FieldType = exports.FeatureName = exports.DisplayType = exports.ConnectorStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let DisplayType = exports.DisplayType = /*#__PURE__*/function (DisplayType) {
  DisplayType["TEXTBOX"] = "textbox";
  DisplayType["TEXTAREA"] = "textarea";
  DisplayType["NUMERIC"] = "numeric";
  DisplayType["TOGGLE"] = "toggle";
  DisplayType["DROPDOWN"] = "dropdown";
  return DisplayType;
}({});
let FieldType = exports.FieldType = /*#__PURE__*/function (FieldType) {
  FieldType["STRING"] = "str";
  FieldType["INTEGER"] = "int";
  FieldType["LIST"] = "list";
  FieldType["BOOLEAN"] = "bool";
  return FieldType;
}({});
let ConnectorStatus = exports.ConnectorStatus = /*#__PURE__*/function (ConnectorStatus) {
  ConnectorStatus["CREATED"] = "created";
  ConnectorStatus["NEEDS_CONFIGURATION"] = "needs_configuration";
  ConnectorStatus["CONFIGURED"] = "configured";
  ConnectorStatus["CONNECTED"] = "connected";
  ConnectorStatus["ERROR"] = "error";
  return ConnectorStatus;
}({});
let SyncStatus = exports.SyncStatus = /*#__PURE__*/function (SyncStatus) {
  SyncStatus["CANCELING"] = "canceling";
  SyncStatus["CANCELED"] = "canceled";
  SyncStatus["COMPLETED"] = "completed";
  SyncStatus["ERROR"] = "error";
  SyncStatus["IN_PROGRESS"] = "in_progress";
  SyncStatus["PENDING"] = "pending";
  SyncStatus["SUSPENDED"] = "suspended";
  return SyncStatus;
}({});
const FilteringRuleRuleValues = exports.FilteringRuleRuleValues = ['contains', 'ends_with', 'equals', '>', '<', 'regex', 'starts_with'];
let FilteringValidationState = exports.FilteringValidationState = /*#__PURE__*/function (FilteringValidationState) {
  FilteringValidationState["EDITED"] = "edited";
  FilteringValidationState["INVALID"] = "invalid";
  FilteringValidationState["VALID"] = "valid";
  return FilteringValidationState;
}({});
let TriggerMethod = exports.TriggerMethod = /*#__PURE__*/function (TriggerMethod) {
  TriggerMethod["ON_DEMAND"] = "on_demand";
  TriggerMethod["SCHEDULED"] = "scheduled";
  return TriggerMethod;
}({});
let SyncJobType = exports.SyncJobType = /*#__PURE__*/function (SyncJobType) {
  SyncJobType["FULL"] = "full";
  SyncJobType["INCREMENTAL"] = "incremental";
  SyncJobType["ACCESS_CONTROL"] = "access_control";
  return SyncJobType;
}({});
let FeatureName = exports.FeatureName = /*#__PURE__*/function (FeatureName) {
  FeatureName["FILTERING_ADVANCED_CONFIG"] = "filtering_advanced_config";
  FeatureName["FILTERING_RULES"] = "filtering_rules";
  FeatureName["DOCUMENT_LEVEL_SECURITY"] = "document_level_security";
  FeatureName["INCREMENTAL_SYNC"] = "incremental_sync";
  FeatureName["SYNC_RULES"] = "sync_rules";
  return FeatureName;
}({});