"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConnectorIndexNames = fetchConnectorIndexNames;
var _ = require("..");
var _identify_exceptions = require("../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function fetchConnectorIndexNames(client) {
  try {
    var _result$hits$hits;
    const result = await client.search({
      _source: false,
      fields: [{
        field: 'index_name'
      }],
      index: _.CONNECTORS_INDEX,
      size: 10000
    });
    return ((_result$hits$hits = result === null || result === void 0 ? void 0 : result.hits.hits) !== null && _result$hits$hits !== void 0 ? _result$hits$hits : []).map(field => {
      var _field$fields$index_n, _field$fields;
      return (_field$fields$index_n = (_field$fields = field.fields) === null || _field$fields === void 0 ? void 0 : _field$fields.index_name[0]) !== null && _field$fields$index_n !== void 0 ? _field$fields$index_n : '';
    });
  } catch (error) {
    if ((0, _identify_exceptions.isIndexNotFoundException)(error)) {
      return [];
    }
    throw error;
  }
}