"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("../..");
var _duration_to_text = require("../../utils/duration_to_text");
var _formatted_date_time = require("../../utils/formatted_date_time");
var _sync_job_flyout = require("./sync_job_flyout");
var _sync_job_cancel_modal = require("./sync_job_cancel_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SyncJobsTable = ({
  isLoading,
  onPaginate,
  pagination,
  syncJobs,
  type,
  cancelConfirmModalProps = {
    onConfirmCb: () => {},
    isLoading: false,
    setSyncJobIdToCancel: () => {},
    syncJobIdToCancel: undefined
  }
}) => {
  const [selectedSyncJob, setSelectedSyncJob] = (0, _react.useState)(undefined);
  const columns = [{
    field: 'completed_at',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.syncJobs.lastSync.columnTitle.tooltip",
        defaultMessage: "The timestamp of a given job's {completed_at}. Syncs complete with a success, an error, or a cancellation.",
        values: {
          completed_at: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "completed_at")
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.syncJobs.lastSync.columnTitle', {
      defaultMessage: 'Last sync'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "questionInCircle",
      color: "subdued",
      className: "eui-alignTop"
    }))),
    render: lastSync => lastSync ? /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(lastSync)
    }) : '--',
    sortable: true,
    truncateText: false
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.syncJobs.syncDuration.columnTitle.tooltip",
        defaultMessage: "Time elapsed between a sync's {started_at} and {completed_at} timestamps. Does not include time spent in \u201Cpending\u201D stage.",
        values: {
          completed_at: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "completed_at"),
          started_at: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "started_at")
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.syncJobs.syncDuration.columnTitle', {
      defaultMessage: 'Sync duration'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "questionInCircle",
      color: "subdued",
      className: "eui-alignTop"
    }))),
    render: syncJob => (0, _duration_to_text.durationToText)((0, _duration_to_text.getSyncJobDuration)(syncJob)),
    truncateText: false
  }, ...(type === 'content' ? [{
    field: 'indexed_document_count',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.index.syncJobs.documents.upserted.tooltip",
        defaultMessage: "Number of {index} operations the connector sent to the Elasticsearch _bulk API, including updates to existing documents. Note that the number of documents upserted and the number of documents in the index may differ.",
        values: {
          index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "index")
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.searchIndices.addedDocs.columnTitle', {
      defaultMessage: 'Docs upserted'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "questionInCircle",
      color: "subdued",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true
  }, {
    field: 'deleted_document_count',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.index.syncJobs.documents.deleted.tooltip",
        defaultMessage: "Number of {delete} operations the connector sent to the Elasticsearch _bulk API. May include documents dropped by Sync Rules. Does not include documents dropped by ingest processors. Documents are deleted when the connector determines they are no longer present in the third-party source.",
        values: {
          delete: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "delete")
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('searchConnectors.searchIndices.deletedDocs.columnTitle', {
      defaultMessage: 'Docs deleted'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "questionInCircle",
      color: "subdued",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true
  }, {
    field: 'job_type',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.syncJobType.columnTitle', {
      defaultMessage: 'Content sync type'
    }),
    render: syncType => {
      const syncJobTypeText = (0, _.syncJobTypeToText)(syncType);
      if (syncJobTypeText.length === 0) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, syncJobTypeText);
    },
    sortable: true,
    truncateText: true
  }] : []), ...(type === 'access_control' ? [{
    field: 'indexed_document_count',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.identitySync.columnTitle', {
      defaultMessage: 'Identities synced'
    }),
    sortable: true,
    truncateText: true
  }] : []), {
    field: 'status',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.syncStatus.columnTitle', {
      defaultMessage: 'Status'
    }),
    render: syncStatus => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _.syncStatusToColor)(syncStatus)
    }, (0, _.syncStatusToText)(syncStatus)),
    truncateText: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.viewJob.title', {
        defaultMessage: 'View this sync job'
      }),
      icon: 'eye',
      isPrimary: false,
      name: _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.viewJob.caption', {
        defaultMessage: 'View this sync job'
      }),
      onClick: job => setSelectedSyncJob(job),
      type: 'icon'
    }, ...(cancelConfirmModalProps ? [{
      render: job => {
        return (0, _.isSyncCancellable)(job.status) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          iconType: "cross",
          color: "danger",
          onClick: () => cancelConfirmModalProps.setSyncJobIdToCancel(job.id),
          "aria-label": _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.cancelSyncJob.caption', {
            defaultMessage: 'Cancel this sync job'
          })
        }, _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.deleteJob.caption', {
          defaultMessage: 'Delete'
        })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
    }] : [])]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Boolean(selectedSyncJob) && /*#__PURE__*/_react.default.createElement(_sync_job_flyout.SyncJobFlyout, {
    onClose: () => setSelectedSyncJob(undefined),
    syncJob: selectedSyncJob
  }), Boolean(cancelConfirmModalProps) && (cancelConfirmModalProps === null || cancelConfirmModalProps === void 0 ? void 0 : cancelConfirmModalProps.syncJobIdToCancel) && /*#__PURE__*/_react.default.createElement(_sync_job_cancel_modal.CancelSyncJobModal, (0, _extends2.default)({}, cancelConfirmModalProps, {
    syncJobId: cancelConfirmModalProps.syncJobIdToCancel,
    onCancel: () => cancelConfirmModalProps.setSyncJobIdToCancel(undefined)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `entSearchContent-index-${type}-syncJobs-table`,
    items: syncJobs,
    columns: columns,
    hasActions: true,
    onChange: onPaginate,
    pagination: pagination,
    tableLayout: "fixed",
    loading: isLoading
  }));
};
exports.SyncJobsTable = SyncJobsTable;