"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorUnconfigured = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ConnectorUnconfigured = ({
  configurationPathOnClick,
  dataTelemetryIdPrefix
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    title: _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.title', {
      defaultMessage: 'Configure your connector to schedule a sync'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.description', {
    defaultMessage: 'Configure and deploy your connector, then return here to set your sync schedule. This schedule will dictate the interval that the connector will sync with your data source for updated documents.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-connector-scheduling-configure`,
    onClick: configurationPathOnClick,
    fill: true,
    size: "s"
  }, _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.button.label', {
    defaultMessage: 'Configure'
  }))));
};
exports.ConnectorUnconfigured = ConnectorUnconfigured;