"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearchAttributeService = getSavedSearchAttributeService;
exports.toSavedSearch = exports.savedObjectToEmbeddableAttributes = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _get_saved_searches = require("../../../common/service/get_saved_searches");
var _check_for_duplicate_title = require("./check_for_duplicate_title");
var _save_saved_searches = require("./save_saved_searches");
var _create_get_saved_search_deps = require("./create_get_saved_search_deps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const savedObjectToEmbeddableAttributes = savedObject => ({
  ...savedObject.attributes,
  references: savedObject.references
});
exports.savedObjectToEmbeddableAttributes = savedObjectToEmbeddableAttributes;
function getSavedSearchAttributeService(services) {
  return services.embeddable.getAttributeService(_discoverUtils.SEARCH_EMBEDDABLE_TYPE, {
    saveMethod: async (attributes, savedObjectId) => {
      const {
        references,
        attributes: attrs
      } = splitReferences(attributes);
      const id = await (0, _save_saved_searches.saveSearchSavedObject)(savedObjectId, attrs, references, services.contentManagement);
      return {
        id
      };
    },
    unwrapMethod: async savedObjectId => {
      const so = await (0, _get_saved_searches.getSearchSavedObject)(savedObjectId, (0, _create_get_saved_search_deps.createGetSavedSearchDeps)(services));
      return {
        attributes: savedObjectToEmbeddableAttributes(so.item),
        metaInfo: {
          sharingSavedObjectProps: so.meta,
          managed: so.item.managed
        }
      };
    },
    checkForDuplicateTitle: props => {
      return (0, _check_for_duplicate_title.checkForDuplicateTitle)({
        title: props.newTitle,
        isTitleDuplicateConfirmed: props.isTitleDuplicateConfirmed,
        onTitleDuplicate: props.onTitleDuplicate,
        contentManagement: services.contentManagement
      });
    }
  });
}
const toSavedSearch = async (id, result, services) => {
  var _result$metaInfo;
  const {
    sharingSavedObjectProps,
    managed
  } = (_result$metaInfo = result.metaInfo) !== null && _result$metaInfo !== void 0 ? _result$metaInfo : {};
  return await (0, _get_saved_searches.convertToSavedSearch)({
    ...splitReferences(result.attributes),
    savedSearchId: id,
    sharingSavedObjectProps,
    managed
  }, (0, _create_get_saved_search_deps.createGetSavedSearchDeps)(services));
};
exports.toSavedSearch = toSavedSearch;
const splitReferences = attributes => {
  var _attrs$description;
  const {
    references,
    ...attrs
  } = attributes;
  return {
    references,
    attributes: {
      ...attrs,
      description: (_attrs$description = attrs.description) !== null && _attrs$description !== void 0 ? _attrs$description : ''
    }
  };
};