"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetSavedSearchDeps = void 0;
var _content_management = require("../../../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createGetSavedSearchDeps = ({
  spaces,
  savedObjectsTaggingOss,
  search,
  contentManagement
}) => ({
  spaces,
  savedObjectsTagging: savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi(),
  searchSourceCreate: search.searchSource.create,
  getSavedSrch: id => {
    return contentManagement.get({
      contentTypeId: _content_management.SavedSearchType,
      id
    });
  }
});
exports.createGetSavedSearchDeps = createGetSavedSearchDeps;