"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchPublicPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("../common");
var _saved_searches_service = require("./services/saved_searches/saved_searches_service");
var _expressions = require("../common/expressions");
var _kibana_context = require("./expressions/kibana_context");
var _saved_searches = require("./services/saved_searches");
var _saved_search_attribute_service = require("./services/saved_searches/saved_search_attribute_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Saved search plugin public Setup contract
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

/**
 * Saved search plugin public Setup contract
 */

/**
 * Saved search plugin public Setup contract
 */

/**
 * Saved search plugin public Setup contract
 */

class SavedSearchPublicPlugin {
  setup({
    getStartServices
  }, {
    contentManagement,
    expressions
  }) {
    contentManagement.registry.register({
      id: _common.SavedSearchType,
      version: {
        latest: _common.LATEST_VERSION
      },
      name: _i18n.i18n.translate('savedSearch.contentManagementType', {
        defaultMessage: 'Saved search'
      })
    });
    expressions.registerFunction((0, _kibana_context.getKibanaContext)({
      getStartServices
    }));
    expressions.registerType(_expressions.kibanaContext);
    (0, _public.registerSavedObjectToPanelMethod)(_common.SavedSearchType, savedObject => {
      if (!savedObject.managed) {
        return {
          savedObjectId: savedObject.id
        };
      }
      return {
        attributes: (0, _saved_search_attribute_service.savedObjectToEmbeddableAttributes)(savedObject)
      };
    });
    return {};
  }
  start(_, {
    data: {
      search
    },
    spaces,
    savedObjectsTaggingOss,
    contentManagement: {
      client: contentManagement
    },
    embeddable
  }) {
    const deps = {
      search,
      spaces,
      savedObjectsTaggingOss,
      contentManagement,
      embeddable
    };
    const service = new _saved_searches_service.SavedSearchesService(deps);
    return {
      get: savedSearchId => service.get(savedSearchId),
      getAll: () => service.getAll(),
      getNew: () => service.getNew(),
      save: (savedSearch, options) => {
        return service.save(savedSearch, options);
      },
      byValue: {
        attributeService: (0, _saved_searches.getSavedSearchAttributeService)(deps),
        toSavedSearch: async (id, result) => {
          return (0, _saved_searches.toSavedSearch)(id, result, deps);
        }
      }
    };
  }
}
exports.SavedSearchPublicPlugin = SavedSearchPublicPlugin;