"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTagReferences = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Extract the tag references from the object's attribute
 *
 * (`extractReferences` is used when persisting the saved object to the backend)
 */
const extractTagReferences = ({
  attributes,
  references
}) => {
  var _ref;
  const {
    __tags,
    ...otherAttributes
  } = attributes;
  const tags = (_ref = [...new Set(__tags)]) !== null && _ref !== void 0 ? _ref : [];
  return {
    attributes: otherAttributes,
    references: [...references, ...tags.map(tagId => ({
      id: tagId,
      type: 'tag',
      name: `tag-${tagId}`
    }))]
  };
};
exports.extractTagReferences = extractTagReferences;