"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectSaveModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const generateId = (0, _eui.htmlIdGenerator)();

/**
 * @deprecated
 * @removeBy 8.8.0
 */
class SavedObjectSaveModal extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "warning", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "formId", generateId('form'));
    (0, _defineProperty2.default)(this, "state", {
      title: this.props.title,
      copyOnSave: Boolean(this.props.initialCopyOnSave),
      isTitleDuplicateConfirmed: false,
      hasTitleDuplicate: false,
      isLoading: false,
      visualizationDescription: this.props.description ? this.props.description : '',
      hasAttemptedSubmit: false
    });
    (0, _defineProperty2.default)(this, "renderViewDescription", () => {
      if (!this.props.showDescription) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.optional",
          defaultMessage: "Optional"
        })),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.descriptionLabel",
          defaultMessage: "Description"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        fullWidth: true,
        "data-test-subj": "viewDescription",
        value: this.state.visualizationDescription,
        onChange: this.onDescriptionChange
      }));
    });
    (0, _defineProperty2.default)(this, "onDescriptionChange", event => {
      this.setState({
        visualizationDescription: event.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onTitleDuplicate", () => {
      this.setState({
        isLoading: false,
        isTitleDuplicateConfirmed: true,
        hasTitleDuplicate: true
      });
      if (this.warning.current) {
        this.warning.current.focus();
      }
    });
    (0, _defineProperty2.default)(this, "saveSavedObject", async () => {
      if (this.state.isLoading) {
        // ignore extra clicks
        return;
      }
      this.setState({
        isLoading: true
      });
      await this.props.onSave({
        newTitle: this.state.title,
        newCopyOnSave: Boolean(this.props.mustCopyOnSaveMessage) || this.state.copyOnSave,
        isTitleDuplicateConfirmed: this.state.isTitleDuplicateConfirmed,
        onTitleDuplicate: this.onTitleDuplicate,
        newDescription: this.state.visualizationDescription
      });
    });
    (0, _defineProperty2.default)(this, "onTitleChange", event => {
      this.setState({
        title: event.target.value,
        isTitleDuplicateConfirmed: false,
        hasTitleDuplicate: false
      });
    });
    (0, _defineProperty2.default)(this, "onCopyOnSaveChange", event => {
      this.setState({
        copyOnSave: event.target.checked
      });
      if (this.props.onCopyOnSaveChange) {
        this.props.onCopyOnSaveChange(event.target.checked);
      }
    });
    (0, _defineProperty2.default)(this, "onFormSubmit", event => {
      event.preventDefault();
      const {
        hasAttemptedSubmit,
        title
      } = this.state;
      if (!hasAttemptedSubmit) {
        this.setState({
          hasAttemptedSubmit: true
        });
      }
      const isValid = this.props.isValid !== undefined ? this.props.isValid : true;
      if (title.length !== 0 && isValid) {
        this.saveSavedObject();
      }
    });
    (0, _defineProperty2.default)(this, "renderConfirmButton", () => {
      const {
        isLoading
      } = this.state;
      let confirmLabel = _i18n.i18n.translate('savedObjects.saveModal.saveButtonLabel', {
        defaultMessage: 'Save'
      });
      if (this.props.confirmButtonLabel) {
        confirmLabel = this.props.confirmButtonLabel;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "confirmSaveSavedObjectButton",
        isLoading: isLoading,
        type: "submit",
        form: this.formId
      }, confirmLabel);
    });
    (0, _defineProperty2.default)(this, "renderDuplicateTitleCallout", duplicateWarningId => {
      if (!this.state.hasTitleDuplicate) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        ref: this.warning,
        tabIndex: -1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.duplicateTitleLabel",
          defaultMessage: "This {objectType} already exists",
          values: {
            objectType: this.props.objectType
          }
        }),
        color: "warning",
        "data-test-subj": "titleDupicateWarnMsg",
        id: duplicateWarningId
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.duplicateTitleDescription",
        defaultMessage: "Saving '{title}' creates a duplicate title.",
        values: {
          title: this.state.title
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
    });
    (0, _defineProperty2.default)(this, "renderCopyOnSave", () => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "saveAsNewCheckbox",
        checked: Boolean(this.props.mustCopyOnSaveMessage) || this.state.copyOnSave,
        disabled: Boolean(this.props.mustCopyOnSaveMessage),
        onChange: this.onCopyOnSaveChange,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.saveAsNewLabel",
          defaultMessage: "Save as new {objectType}",
          values: {
            objectType: this.props.objectType
          }
        })
      })), this.props.mustCopyOnSaveMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          marginLeft: `-${_uiTheme.euiThemeVars.euiSize}`
        },
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "iInCircle",
        content: this.props.mustCopyOnSaveMessage
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }));
    });
  }
  render() {
    const {
      isTitleDuplicateConfirmed,
      hasTitleDuplicate,
      title,
      hasAttemptedSubmit
    } = this.state;
    const duplicateWarningId = generateId();
    const hasColumns = !!this.props.rightOptions;
    const titleInputValid = hasAttemptedSubmit && (!isTitleDuplicateConfirmed && hasTitleDuplicate || title.length === 0);
    const formBodyContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.titleLabel",
        defaultMessage: "Title"
      }),
      isInvalid: titleInputValid,
      error: _i18n.i18n.translate('savedObjects.saveModal.titleRequired', {
        defaultMessage: 'A title is required'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      autoFocus: true,
      "data-test-subj": "savedObjectTitle",
      value: title,
      onChange: this.onTitleChange,
      isInvalid: titleInputValid,
      "aria-describedby": this.state.hasTitleDuplicate ? duplicateWarningId : undefined
    })), this.renderViewDescription(), typeof this.props.options === 'function' ? this.props.options(this.state) : this.props.options);
    const formBody = hasColumns ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, formBodyContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, typeof this.props.rightOptions === 'function' ? this.props.rightOptions(this.state) : this.props.rightOptions)) : formBodyContent;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "savedObjectSaveModal",
      className: `kbnSavedObjectSaveModal${hasColumns ? ' kbnSavedObjectsSaveModal--wide' : ''}`,
      onClose: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, this.props.customModalTitle ? this.props.customModalTitle : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.saveTitle",
      defaultMessage: "Save {objectType}",
      values: {
        objectType: this.props.objectType
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, this.renderDuplicateTitleCallout(duplicateWarningId), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      onSubmit: this.onFormSubmit,
      id: this.formId
    }, !this.props.showDescription && this.props.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, this.props.description), formBody)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center"
    }, this.props.showCopyOnSave && this.renderCopyOnSave(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "saveCancelButton",
      onClick: this.props.onClose
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.renderConfirmButton()))));
  }
}
exports.SavedObjectSaveModal = SavedObjectSaveModal;