"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsForNotification = getAlertsForNotification;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsForNotification(flappingSettings, alertDelay, trackedEventsToIndex, newEventsToIndex, newEventParams) {
  const events = [];
  for (const trackedEvent of [...newEventsToIndex, ...trackedEventsToIndex]) {
    if (trackedEvent.event[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE) {
      const count = trackedEvent.activeCount || 0;
      trackedEvent.activeCount = count + 1;
      trackedEvent.pendingRecoveredCount = 0;
      // do not index the event if the number of consecutive
      // active alerts is less than the rule alertDelay threshold
      if (trackedEvent.activeCount < alertDelay) {
        // remove from array of events to index
        continue;
      } else {
        const {
          timestamp,
          maintenanceWindowIds
        } = newEventParams;
        // if the active count is equal to the alertDelay it is considered a new event
        if (trackedEvent.activeCount === alertDelay) {
          // update the event to look like a new event
          trackedEvent.event[_ruleDataUtils.ALERT_DURATION] = 0;
          trackedEvent.event[_ruleDataUtils.ALERT_START] = timestamp;
          trackedEvent.event[_ruleDataUtils.ALERT_TIME_RANGE] = {
            gte: timestamp
          };
          trackedEvent.event[_ruleDataUtils.EVENT_ACTION] = 'open';
          if (maintenanceWindowIds !== null && maintenanceWindowIds !== void 0 && maintenanceWindowIds.length) {
            trackedEvent.event[_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS] = maintenanceWindowIds;
          }
        }
      }
    } else if (trackedEvent.event[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_RECOVERED) {
      trackedEvent.activeCount = 0;
      if (flappingSettings.enabled) {
        if (trackedEvent.flapping) {
          const count = trackedEvent.pendingRecoveredCount || 0;
          trackedEvent.pendingRecoveredCount = count + 1;
          if (trackedEvent.pendingRecoveredCount < flappingSettings.statusChangeThreshold) {
            trackedEvent.event[_ruleDataUtils.ALERT_STATUS] = _ruleDataUtils.ALERT_STATUS_ACTIVE;
            trackedEvent.event[_ruleDataUtils.EVENT_ACTION] = 'active';
            delete trackedEvent.event[_ruleDataUtils.ALERT_END];
          } else {
            trackedEvent.pendingRecoveredCount = 0;
          }
        }
      } else {
        trackedEvent.pendingRecoveredCount = 0;
      }
    }
    trackedEvent.event[_ruleDataUtils.ALERT_CONSECUTIVE_MATCHES] = trackedEvent.activeCount;
    events.push(trackedEvent);
  }
  return events;
}