"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBrowserFieldsByFeatureId = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../common/constants");
var _route_validation = require("./utils/route_validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBrowserFieldsByFeatureId = router => {
  router.get({
    path: `${_constants.BASE_RAC_ALERTS_API_PATH}/browser_fields`,
    validate: {
      query: (0, _route_validation.buildRouteValidation)(t.exact(t.type({
        featureIds: t.union([t.string, t.array(t.string)])
      })))
    },
    options: {
      tags: ['access:rac']
    }
  }, async (context, request, response) => {
    try {
      var _ref;
      const racContext = await context.rac;
      const alertsClient = await racContext.getAlertsClient();
      const {
        featureIds = []
      } = request.query;
      const onlyO11yFeatureIds = (Array.isArray(featureIds) ? featureIds : [featureIds]).filter(fId => fId !== 'siem');
      const o11yIndices = (_ref = onlyO11yFeatureIds ? await alertsClient.getAuthorizedAlertsIndices(onlyO11yFeatureIds) : []) !== null && _ref !== void 0 ? _ref : [];
      if (o11yIndices.length === 0) {
        return response.notFound({
          body: {
            message: `No alerts-observability indices found for featureIds [${featureIds}]`,
            attributes: {
              success: false
            }
          }
        });
      }
      const fields = await alertsClient.getBrowserFields({
        indices: o11yIndices,
        featureIds: onlyO11yFeatureIds,
        metaFields: ['_id', '_index'],
        allowNoIndex: true
      });
      return response.ok({
        body: fields
      });
    } catch (error) {
      const formatedError = (0, _securitysolutionEsUtils.transformError)(error);
      const contentType = {
        'content-type': 'application/json'
      };
      const defaultedHeaders = {
        ...contentType
      };
      return response.customError({
        headers: defaultedHeaders,
        statusCode: formatedError.statusCode,
        body: {
          message: formatedError.message,
          attributes: {
            success: false
          }
        }
      });
    }
  });
};
exports.getBrowserFieldsByFeatureId = getBrowserFieldsByFeatureId;