"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_BURN_RATE_RULE_TYPE_ID = exports.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.LOG_THRESHOLD_ALERT_TYPE_ID = exports.ApmRuleType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = exports.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID = 'observability.rules.custom_threshold';
const SLO_BURN_RATE_RULE_TYPE_ID = exports.SLO_BURN_RATE_RULE_TYPE_ID = 'slo.rules.burnRate';
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
const METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';
const LOG_THRESHOLD_ALERT_TYPE_ID = exports.LOG_THRESHOLD_ALERT_TYPE_ID = 'logs.alert.document.count';
let ApmRuleType = exports.ApmRuleType = /*#__PURE__*/function (ApmRuleType) {
  ApmRuleType["ErrorCount"] = "apm.error_rate";
  ApmRuleType["TransactionErrorRate"] = "apm.transaction_error_rate";
  ApmRuleType["TransactionDuration"] = "apm.transaction_duration";
  ApmRuleType["Anomaly"] = "apm.anomaly";
  return ApmRuleType;
}({});