"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOperationIdCounter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createOperationIdCounter = () => {
  const operationIdCounters = new Map();
  return name => {
    var _operationIdCounters$;
    // Aliases an operationId to ensure it is unique across
    // multiple method+path combinations sharing a name.
    // "search" -> "search#0", "search#1", etc.
    const operationIdCount = (_operationIdCounters$ = operationIdCounters.get(name)) !== null && _operationIdCounters$ !== void 0 ? _operationIdCounters$ : 0;
    const aliasedName = name + '#' + operationIdCount.toString();
    operationIdCounters.set(name, operationIdCount + 1);
    return aliasedName;
  };
};
exports.createOperationIdCounter = createOperationIdCounter;