"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processRef = void 0;
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const processRef = (ctx, schema) => {
  const result = (0, _lib.tryConvertToRef)(schema);
  if (result) {
    const [id, s] = result.idSchema;
    ctx.sharedSchemas.set(id, s);
    return result.ref;
  }
};
exports.processRef = processRef;