"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "createCtx", {
  enumerable: true,
  get: function () {
    return _context.createCtx;
  }
});
exports.postProcessMutations = void 0;
var mutations = _interopRequireWildcard(require("./mutations"));
var _context = require("./context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const postProcessMutations = ({
  ctx,
  schema
}) => {
  walkSchema(ctx, schema);
  return ctx;
};
exports.postProcessMutations = postProcessMutations;
const arrayContainers = ['allOf', 'oneOf', 'anyOf'];
const walkSchema = (ctx, schema) => {
  mutations.processAny(schema);
  if (schema.type === 'array') {
    walkSchema(ctx, schema.items);
  } else if (schema.type === 'object') {
    if (schema.properties) {
      Object.values(schema.properties).forEach(value => {
        walkSchema(ctx, value);
      });
    }
    mutations.processObject(ctx, schema);
  } else if (schema.type === 'record') {
    mutations.processRecord(ctx, schema);
  } else if (schema.type === 'map') {
    mutations.processMap(ctx, schema);
  } else if (schema.type === 'string') {
    mutations.processString(schema);
  } else if (schema.type) {
    // Do nothing
  } else {
    for (const arrayContainer of arrayContainers) {
      if (schema[arrayContainer]) {
        schema[arrayContainer].forEach((s, idx) => {
          walkSchema(ctx, s);
          schema[arrayContainer][idx] = ctx.processRef(s);
        });
        break;
      }
    }
  }
};