"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCtx = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ref = require("./mutations/ref");
var _lib = require("../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Context {
  constructor(opts) {
    var _opts$sharedSchemas;
    (0, _defineProperty2.default)(this, "sharedSchemas", void 0);
    (0, _defineProperty2.default)(this, "refs", void 0);
    this.sharedSchemas = (_opts$sharedSchemas = opts.sharedSchemas) !== null && _opts$sharedSchemas !== void 0 ? _opts$sharedSchemas : new Map();
    this.refs = !!opts.refs;
  }
  processRef(schema) {
    if (this.refs) {
      var _processRefMutation;
      return (_processRefMutation = (0, _ref.processRef)(this, schema)) !== null && _processRefMutation !== void 0 ? _processRefMutation : schema;
    }
    return (0, _lib.removeSharedComponentId)(schema);
  }
}
const createCtx = (opts = {
  sharedSchemas: new Map()
}) => {
  return new Context(opts);
};
exports.createCtx = createCtx;