"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobListUi = exports.JobList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _services = require("../../services");
var _documentation_links = require("../../services/documentation_links");
var _job_table = require("./job_table");
var _detail_panel = require("./detail_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_RATE_MS = 30000;
class JobListUi extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      openDetailPanel,
      history: {
        location: {
          search
        }
      }
    } = props;
    const {
      job: jobId
    } = (0, _shared_imports.extractQueryParams)(search);

    // Show deeplinked job whenever jobs get loaded or the URL changes.
    if (jobId != null) {
      openDetailPanel(jobId);
    }
    return null;
  }
  constructor(props) {
    super(props);
    props.loadJobs();
    props.kibana.services.setBreadcrumbs([_services.listBreadcrumb]);
    this.state = {};
  }
  componentDidMount() {
    this.interval = setInterval(() => this.props.refreshJobs({
      asSystemRequest: true
    }), REFRESH_RATE_MS);
  }
  componentWillUnmount() {
    clearInterval(this.interval);

    // Close the panel, otherwise it will default to already being open when we navigate back to
    // this page.
    this.props.closeDetailPanel();
  }
  renderNoPermission() {
    const title = _i18n.i18n.translate('xpack.rollupJobs.jobList.noPermissionTitle', {
      defaultMessage: 'Permission error'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": "jobListNoPermission",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", null, title),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobList.noPermissionText",
        defaultMessage: "You do not have permission to view or add rollup jobs."
      }))
    }));
  }
  renderError(error) {
    // We can safely depend upon the shape of this error coming from http service, because we
    // handle unexpected error shapes in the API action.
    const {
      statusCode,
      error: errorString
    } = error.body;
    const title = _i18n.i18n.translate('xpack.rollupJobs.jobList.loadingErrorTitle', {
      defaultMessage: 'Error loading rollup jobs'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": "jobListError",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h1", null, title),
      body: /*#__PURE__*/_react.default.createElement("p", null, statusCode, " ", errorString)
    }));
  }
  renderEmpty() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "subdued",
      "data-test-subj": "jobListEmptyPrompt",
      iconType: "indexRollupApp",
      title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobList.emptyPromptTitle",
        defaultMessage: "Create your first rollup job"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobList.emptyPromptDescription",
        defaultMessage: "Rollup jobs summarize and store historical data in a smaller index for future analysis."
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        "data-test-subj": "createRollupJobButton"
      }, (0, _services.getRouterLinkProps)('/create'), {
        fill: true,
        iconType: "plusInCircle"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobList.emptyPrompt.createButtonLabel",
        defaultMessage: "Create rollup job"
      }))
    }));
  }
  renderLoading() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.jobList.loadingTitle",
      defaultMessage: "Loading rollup jobs\u2026"
    })));
  }
  renderList() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "jobListPageHeader"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobListTitle",
        defaultMessage: "Rollup Jobs"
      })),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: _documentation_links.documentationLinks.rollupJobs,
        target: "_blank",
        iconType: "help",
        "data-test-subj": "documentationLink"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.rollupJobsDocsLinkText",
        defaultMessage: "Rollup Jobs docs"
      }))]
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_job_table.JobTable, null), /*#__PURE__*/_react.default.createElement(_detail_panel.DetailPanel, null));
  }
  render() {
    const {
      isLoading,
      hasJobs,
      jobLoadError
    } = this.props;
    let content;
    if (jobLoadError) {
      if (jobLoadError.status === 403) {
        content = this.renderNoPermission();
      } else {
        content = this.renderError(jobLoadError);
      }
    } else if (!isLoading && !hasJobs) {
      content = this.renderEmpty();
    } else if (isLoading) {
      content = this.renderLoading();
    } else {
      content = this.renderList();
    }
    return content;
  }
}
exports.JobListUi = JobListUi;
(0, _defineProperty2.default)(JobListUi, "propTypes", {
  loadJobs: _propTypes.default.func,
  refreshJobs: _propTypes.default.func,
  openDetailPanel: _propTypes.default.func,
  hasJobs: _propTypes.default.bool,
  isLoading: _propTypes.default.bool
});
const JobList = exports.JobList = (0, _public.withKibana)(JobListUi);