"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectApp = void 0;
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
require("./redirect_app.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  errorTitle: _i18n.i18n.translate('xpack.reporting.redirectApp.errorTitle', {
    defaultMessage: 'Redirect error'
  }),
  consoleMessagePrefix: _i18n.i18n.translate('xpack.reporting.redirectApp.redirectConsoleErrorPrefixLabel', {
    defaultMessage: 'Redirect page error:'
  })
};
const RedirectApp = ({
  apiClient,
  screenshotMode,
  share
}) => {
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    (async () => {
      try {
        let locatorParams;
        const {
          jobId
        } = (0, _queryString.parse)(window.location.search);
        if (jobId) {
          var _result$locatorParams;
          const result = await apiClient.getInfo(jobId);
          locatorParams = result === null || result === void 0 ? void 0 : (_result$locatorParams = result.locatorParams) === null || _result$locatorParams === void 0 ? void 0 : _result$locatorParams[0];
        } else {
          locatorParams = screenshotMode.getScreenshotContext(_reportingCommon.REPORTING_REDIRECT_LOCATOR_STORE_KEY);
        }
        if (!locatorParams) {
          throw new Error('Could not find locator params for report');
        }
        share.navigate(locatorParams);
      } catch (e) {
        setError(e);
        // eslint-disable-next-line no-console
        console.error(i18nTexts.consoleMessagePrefix, e.message);
        throw e;
      }
    })();
  }, [apiClient, screenshotMode, share]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reportingRedirectApp__interstitialPage"
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.errorTitle,
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, error.message), error.stack && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, error.stack)) :
  /*#__PURE__*/
  // We don't show anything on this page, the share service will handle showing any issues with
  // using the locator
  _react.default.createElement("div", null));
};
exports.RedirectApp = RedirectApp;