"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _share = require("@kbn/reporting-public/share");
var _reportingCsvSharePanel = require("@kbn/reporting-csv-share-panel");
var _stream_handler = require("./lib/stream_handler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * @internal
 * @implements Plugin
 */
class ReportingPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "apiClient", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "title", _i18n.i18n.translate('xpack.reporting.management.reportingTitle', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "breadcrumbText", _i18n.i18n.translate('xpack.reporting.breadcrumb', {
      defaultMessage: 'Reporting'
    }));
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "contract", void 0);
    this.config = initializerContext.config.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }

  /*
   * Use a single instance of ReportingAPIClient for all the reporting code
   */
  getApiClient(http, uiSettings) {
    if (!this.apiClient) {
      this.apiClient = new _reportingPublic.ReportingAPIClient(http, uiSettings, this.kibanaVersion);
    }
    return this.apiClient;
  }
  getContract(core) {
    if (core) {
      this.contract = {
        usesUiCapabilities: () => {
          var _this$config$roles;
          return ((_this$config$roles = this.config.roles) === null || _this$config$roles === void 0 ? void 0 : _this$config$roles.enabled) === false;
        },
        components: (0, _share.getSharedComponents)(core, this.getApiClient(core.http, core.uiSettings))
      };
    }
    if (!this.contract) {
      throw new Error(`Setup error in Reporting plugin!`);
    }
    return this.contract;
  }
  setup(core, setupDeps) {
    const {
      getStartServices,
      uiSettings
    } = core;
    const {
      home: homeSetup,
      management: managementSetup,
      screenshotMode: screenshotModeSetup,
      share: shareSetup,
      uiActions: uiActionsSetup
    } = setupDeps;
    const startServices$ = (0, _rxjs.from)(getStartServices());
    const usesUiCapabilities = !this.config.roles.enabled;
    const apiClient = this.getApiClient(core.http, core.uiSettings);
    homeSetup.featureCatalogue.register({
      id: 'reporting',
      title: _i18n.i18n.translate('xpack.reporting.registerFeature.reportingTitle', {
        defaultMessage: 'Reporting'
      }),
      description: _i18n.i18n.translate('xpack.reporting.registerFeature.reportingDescription', {
        defaultMessage: 'Manage your reports generated from Discover, Visualize, and Dashboard.'
      }),
      icon: 'reportingApp',
      path: '/app/management/insightsAndAlerting/reporting',
      showOnHomePage: false,
      category: 'admin'
    });
    managementSetup.sections.section.insightsAndAlerting.registerApp({
      id: 'reporting',
      title: this.title,
      order: 3,
      mount: async params => {
        params.setBreadcrumbs([{
          text: this.breadcrumbText
        }]);
        const [[coreStart, startDeps], {
          mountManagementSection
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./management/mount_management_section')))]);
        const {
          licensing,
          data,
          share
        } = startDeps;
        const {
          docTitle
        } = coreStart.chrome;
        docTitle.change(this.title);
        const umountAppCallback = await mountManagementSection(coreStart, licensing.license$, data, share, this.config, apiClient, params);
        return () => {
          docTitle.reset();
          umountAppCallback();
        };
      }
    });
    core.application.register({
      id: 'reportingRedirect',
      mount: async params => {
        const {
          mountRedirectApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./redirect')));
        return mountRedirectApp({
          ...params,
          apiClient,
          screenshotMode: screenshotModeSetup,
          share: shareSetup
        });
      },
      title: 'Reporting redirect app',
      chromeless: true,
      exactRoute: true,
      visibleIn: []
    });
    uiActionsSetup.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, new _reportingCsvSharePanel.ReportingCsvPanelAction({
      core,
      apiClient,
      startServices$,
      usesUiCapabilities,
      csvConfig: this.config.csv
    }));
    const reportingStart = this.getContract(core);
    const {
      toasts
    } = core.notifications;
    startServices$.subscribe(([{
      application,
      i18n: i18nStart
    }, {
      licensing
    }]) => {
      licensing.license$.subscribe(license => {
        shareSetup.register((0, _share.reportingCsvShareProvider)({
          apiClient,
          toasts,
          uiSettings,
          license,
          application,
          usesUiCapabilities,
          theme: core.theme
        }));
        if (this.config.export_types.pdf.enabled || this.config.export_types.png.enabled) {
          // needed for Canvas and legacy tests
          shareSetup.register((0, _share.reportingScreenshotShareProvider)({
            apiClient,
            toasts,
            uiSettings,
            license,
            application,
            usesUiCapabilities,
            theme: core.theme
          }));
        }
        if (shareSetup.isNewVersion()) {
          shareSetup.register((0, _share.reportingCsvShareModalProvider)({
            apiClient,
            uiSettings,
            license,
            application,
            usesUiCapabilities,
            theme: core.theme,
            i18n: i18nStart
          }));
          if (this.config.export_types.pdf.enabled || this.config.export_types.png.enabled) {
            shareSetup.register((0, _share.reportingExportModalProvider)({
              apiClient,
              uiSettings,
              license,
              application,
              usesUiCapabilities,
              theme: core.theme,
              i18n: i18nStart
            }));
          }
        }
      });
    });
    return reportingStart;
  }
  start(core) {
    const {
      notifications,
      docLinks
    } = core;
    const apiClient = this.getApiClient(core.http, core.uiSettings);
    const streamHandler = new _stream_handler.ReportingNotifierStreamHandler(notifications, apiClient, core.theme, docLinks);
    const interval = (0, _reportingCommon.durationToNumber)(this.config.poll.jobsRefresh.interval);
    streamHandler.startPolling(interval, this.stop$);
    return this.getContract();
  }
  stop() {
    this.stop$.next();
  }
}
exports.ReportingPublicPlugin = ReportingPublicPlugin;