"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailureToast = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var errors = _interopRequireWildcard(require("@kbn/reporting-common/errors"));
var _shared_i18n_texts = require("../shared_i18n_texts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFailureToast = (errorText, job, getManagmenetLink, theme, docLinks) => {
  return {
    title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.couldNotCreateReportTitle",
      defaultMessage: "Cannot create {reportType} report for '{reportObjectTitle}'.",
      values: {
        reportType: job.jobtype,
        reportObjectTitle: job.title
      }
    }), {
      theme$: theme.theme$
    }),
    text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "danger",
      "data-test-errorText": errorText
    }, job.errorCode === errors.VisualReportingSoftDisabledError.code ? _shared_i18n_texts.sharedI18nTexts.cloud.insufficientMemoryError(docLinks.links.reporting.cloudMinimumRequirements) : errorText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.publicNotifier.error.checkManagement",
      defaultMessage: "Go to {path} for details.",
      values: {
        path: /*#__PURE__*/_react.default.createElement("a", {
          href: getManagmenetLink()
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.reporting.publicNotifier.error.reportingSectionUrlLinkLabel",
          defaultMessage: "Stack Management > Kibana > Reporting"
        }))
      }
    }))), {
      theme$: theme.theme$
    }),
    iconType: undefined,
    'data-test-subj': 'completeReportFailure'
  };
};
exports.getFailureToast = getFailureToast;