"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobHasIssues = exports.guessAppIconTypeFromObjectType = void 0;
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is not the most forward-compatible way of mapping to an {@link IconType} for an application.
 *
 * Ideally apps using reporting should send some metadata for the icon type they want - this is how
 * the saved objects management UI handles icons at the moment.
 */
const guessAppIconTypeFromObjectType = type => {
  switch (type) {
    case 'search':
      return 'discoverApp';
    case 'dashboard':
      return 'dashboardApp';
    case 'visualization':
      return 'visualizeApp';
    case 'canvas workpad':
      return 'canvasApp';
    case 'lens':
      return 'lensApp';
    default:
      return 'apps';
  }
};
exports.guessAppIconTypeFromObjectType = guessAppIconTypeFromObjectType;
const jobHasIssues = job => {
  return Boolean(job.getWarnings()) || [_reportingCommon.JOB_STATUS.WARNINGS, _reportingCommon.JOB_STATUS.FAILED].some(status => job.status === status);
};
exports.jobHasIssues = jobHasIssues;