"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportListingTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _job_utils = require("../../common/job_utils");
var _poller = require("../../common/poller");
var _components = require("./components");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ReportListingTable extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "isInitialJobsFetch", void 0);
    (0, _defineProperty2.default)(this, "licenseSubscription", void 0);
    (0, _defineProperty2.default)(this, "mounted", void 0);
    (0, _defineProperty2.default)(this, "poller", void 0);
    (0, _defineProperty2.default)(this, "licenseHandler", license => {
      const {
        enableLinks,
        showLinks,
        message: badLicenseMessage
      } = (0, _reportingPublic.checkLicense)(license.check('reporting', 'basic'));
      this.setState({
        enableLinks,
        showLinks,
        badLicenseMessage
      });
    });
    (0, _defineProperty2.default)(this, "onSelectionChange", jobs => {
      this.setState(current => ({
        ...current,
        selectedJobs: jobs
      }));
    });
    (0, _defineProperty2.default)(this, "removeJob", job => {
      const {
        jobs
      } = this.state;
      const filtered = jobs.filter(j => j.id !== job.id);
      this.setState(current => ({
        ...current,
        jobs: filtered
      }));
    });
    (0, _defineProperty2.default)(this, "renderDeleteButton", () => {
      const {
        selectedJobs
      } = this.state;
      if (selectedJobs.length === 0) return undefined;
      const performDelete = async () => {
        for (const job of selectedJobs) {
          try {
            await this.props.apiClient.deleteReport(job.id);
            this.removeJob(job);
            this.props.toasts.addSuccess(_i18n.i18n.translate('xpack.reporting.listing.table.deleteConfim', {
              defaultMessage: `The {reportTitle} report was deleted`,
              values: {
                reportTitle: job.title
              }
            }));
          } catch (error) {
            this.props.toasts.addDanger(_i18n.i18n.translate('xpack.reporting.listing.table.deleteFailedErrorMessage', {
              defaultMessage: `The report was not deleted: {error}`,
              values: {
                error
              }
            }));
            throw error;
          }
        }
      };
      return /*#__PURE__*/_react.default.createElement(_components.ReportDeleteButton, (0, _extends2.default)({
        jobsToDelete: selectedJobs,
        performDelete: performDelete
      }, this.props));
    });
    (0, _defineProperty2.default)(this, "onTableChange", ({
      page
    }) => {
      const {
        index: pageIndex
      } = page;
      this.setState(() => ({
        page: pageIndex
      }), this.fetchJobs);
    });
    (0, _defineProperty2.default)(this, "fetchJobs", async () => {
      // avoid page flicker when poller is updating table - only display loading screen on first load
      if (this.isInitialJobsFetch) {
        this.setState(() => ({
          isLoading: true
        }));
      }
      let jobs;
      let total;
      try {
        jobs = await this.props.apiClient.list(this.state.page);
        total = await this.props.apiClient.total();
        this.isInitialJobsFetch = false;
      } catch (fetchError) {
        if (!this.licenseAllowsToShowThisPage()) {
          this.props.toasts.addDanger(this.state.badLicenseMessage);
          this.props.redirect('management');
          return;
        }
        if (fetchError.message === 'Failed to fetch') {
          this.props.toasts.addDanger(fetchError.message || _i18n.i18n.translate('xpack.reporting.listing.table.requestFailedErrorMessage', {
            defaultMessage: 'Request failed'
          }));
        }
        if (this.mounted) {
          this.setState(() => ({
            isLoading: false,
            jobs: [],
            total: 0
          }));
        }
        return;
      }
      if (this.mounted) {
        this.setState(() => ({
          isLoading: false,
          total,
          jobs
        }));
      }
    });
    (0, _defineProperty2.default)(this, "licenseAllowsToShowThisPage", () => {
      return this.state.showLinks && this.state.enableLinks;
    });
    /**
     * Widths like this are not the best, but the auto-layout does not play well with text in links. We can update
     * this with something that works better on all screen sizes. This works for desktop, mobile fallback is provided on a
     * per column basis.
     */
    (0, _defineProperty2.default)(this, "tableColumnWidths", {
      type: '5%',
      title: '30%',
      status: '20%',
      createdAt: '25%',
      content: '10%',
      actions: '10%'
    });
    this.state = {
      page: 0,
      total: 0,
      jobs: [],
      selectedJobs: [],
      isLoading: false,
      showLinks: false,
      enableLinks: false,
      badLicenseMessage: '',
      selectedJob: undefined
    };
    this.isInitialJobsFetch = true;
  }
  componentWillUnmount() {
    var _this$poller;
    this.mounted = false;
    (_this$poller = this.poller) === null || _this$poller === void 0 ? void 0 : _this$poller.stop();
    if (this.licenseSubscription) {
      this.licenseSubscription.unsubscribe();
    }
  }
  componentDidMount() {
    this.mounted = true;
    const {
      config,
      license$
    } = this.props;
    const pollFrequencyInMillis = (0, _reportingCommon.durationToNumber)(config.poll.jobsRefresh.interval);
    this.poller = new _poller.Poller({
      functionToPoll: () => {
        return this.fetchJobs();
      },
      pollFrequencyInMillis,
      trailing: false,
      continuePollingOnError: true,
      pollFrequencyErrorMultiplier: config.poll.jobsRefresh.intervalErrorMultiplier
    });
    this.poller.start();
    this.licenseSubscription = license$.subscribe(this.licenseHandler);
  }
  render() {
    const {
      tableColumnWidths
    } = this;
    const tableColumns = [{
      field: 'type',
      width: tableColumnWidths.type,
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.typeTitle', {
        defaultMessage: 'Type'
      }),
      render: (_type, job) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          className: "kbnReporting__reportListing__typeIcon"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: (0, _utils.guessAppIconTypeFromObjectType)(job.objectType),
          size: "s",
          "data-test-subj": "reportJobType",
          content: job.objectType
        }));
      },
      mobileOptions: {
        show: true,
        render: job => {
          return /*#__PURE__*/_react.default.createElement("div", {
            "data-test-subj": "reportJobType"
          }, job.objectType);
        }
      }
    }, {
      field: 'title',
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.reportTitle', {
        defaultMessage: 'Title'
      }),
      width: tableColumnWidths.title,
      render: (objectTitle, job) => {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "reportingListItemObjectTitle"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": `viewReportingLink-${job.id}`,
          onClick: () => this.setState({
            selectedJob: job
          })
        }, objectTitle || _i18n.i18n.translate('xpack.reporting.listing.table.noTitleLabel', {
          defaultMessage: 'Untitled'
        })));
      },
      mobileOptions: {
        header: false,
        width: '100%' // This is not recognized by EUI types but has an effect, leaving for now
      }
    }, {
      field: 'status',
      width: tableColumnWidths.status,
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.statusTitle', {
        defaultMessage: 'Status'
      }),
      render: (_status, job) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "none",
          responsive: false,
          alignItems: "center",
          "data-test-subj": "reportJobStatus"
        }, /*#__PURE__*/_react.default.createElement(_components.ReportStatusIndicator, {
          job: job
        }));
      },
      mobileOptions: {
        show: false
      }
    }, {
      field: 'created_at',
      width: tableColumnWidths.createdAt,
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.createdAtTitle', {
        defaultMessage: 'Created at'
      }),
      render: (_createdAt, job) => /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "reportJobCreatedAt"
      }, job.getCreatedAtDate()),
      mobileOptions: {
        show: false
      }
    }, {
      field: 'content',
      width: tableColumnWidths.content,
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.content', {
        defaultMessage: 'Content'
      }),
      render: (_status, job) => (0, _job_utils.prettyPrintJobType)(job.jobtype),
      mobileOptions: {
        show: false
      }
    }, {
      name: _i18n.i18n.translate('xpack.reporting.listing.tableColumns.actionsTitle', {
        defaultMessage: 'Actions'
      }),
      width: tableColumnWidths.actions,
      actions: [{
        isPrimary: true,
        'data-test-subj': 'reportDownloadLink',
        type: 'icon',
        icon: 'download',
        name: _i18n.i18n.translate('xpack.reporting.listing.table.downloadReportButtonLabel', {
          defaultMessage: 'Download report'
        }),
        description: _i18n.i18n.translate('xpack.reporting.listing.table.downloadReportDescription', {
          defaultMessage: 'Download this report in a new tab.'
        }),
        onClick: job => this.props.apiClient.downloadReport(job.id),
        enabled: job => job.isDownloadReady
      }, {
        name: _i18n.i18n.translate('xpack.reporting.listing.table.viewReportingInfoActionButtonLabel', {
          defaultMessage: 'View report info'
        }),
        description: _i18n.i18n.translate('xpack.reporting.listing.table.viewReportingInfoActionButtonDescription', {
          defaultMessage: 'View additional information about this report.'
        }),
        type: 'icon',
        icon: 'iInCircle',
        onClick: job => this.setState({
          selectedJob: job
        })
      }, {
        name: _i18n.i18n.translate('xpack.reporting.listing.table.openInKibanaAppLabel', {
          defaultMessage: 'Open in Kibana'
        }),
        'data-test-subj': 'reportOpenInKibanaApp',
        description: _i18n.i18n.translate('xpack.reporting.listing.table.openInKibanaAppDescription', {
          defaultMessage: 'Open the Kibana app where this report was generated.'
        }),
        available: job => job.canLinkToKibanaApp,
        type: 'icon',
        icon: 'popout',
        onClick: job => {
          const href = this.props.apiClient.getKibanaAppHref(job);
          window.open(href, '_blank');
          window.focus();
        }
      }]
    }];
    const pagination = {
      pageIndex: this.state.page,
      pageSize: 10,
      totalItemCount: this.state.total,
      showPerPageOptions: false
    };
    const selection = {
      itemId: 'id',
      onSelectionChange: this.onSelectionChange
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.state.selectedJobs.length > 0 && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.renderDeleteButton())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.reporting.listing.table.captionDescription', {
        defaultMessage: 'Reports generated in Kibana applications'
      }),
      itemId: "id",
      items: this.state.jobs,
      loading: this.state.isLoading,
      columns: tableColumns,
      noItemsMessage: this.state.isLoading ? _i18n.i18n.translate('xpack.reporting.listing.table.loadingReportsDescription', {
        defaultMessage: 'Loading reports'
      }) : _i18n.i18n.translate('xpack.reporting.listing.table.noCreatedReportsDescription', {
        defaultMessage: 'No reports have been created'
      }),
      pagination: pagination,
      selection: selection,
      isSelectable: true,
      onChange: this.onTableChange,
      "data-test-subj": _reportingCommon.REPORT_TABLE_ID,
      rowProps: () => ({
        'data-test-subj': _reportingCommon.REPORT_TABLE_ROW_ID
      })
    }), !!this.state.selectedJob && /*#__PURE__*/_react.default.createElement(_components.ReportInfoFlyout, {
      config: this.props.config,
      onClose: () => this.setState({
        selectedJob: undefined
      }),
      job: this.state.selectedJob
    }));
  }
}
exports.ReportListingTable = ReportListingTable;