"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportListing = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
require("./report_listing.scss");
var _reportingPublic = require("@kbn/reporting-public");
var _report_listing_stateful = require("./stateful/report_listing_stateful");
var _report_listing_default = require("./default/report_listing_default");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReportListing = props => {
  const {
    apiClient
  } = (0, _reportingPublic.useInternalApiClient)();
  const {
    services: {
      application: {
        capabilities
      }
    }
  } = (0, _reportingPublic.useKibana)();
  return props.config.statefulSettings.enabled ? /*#__PURE__*/_react.default.createElement(_report_listing_stateful.ReportListingStateful, (0, _extends2.default)({}, props, {
    apiClient: apiClient,
    capabilities: capabilities
  })) : /*#__PURE__*/_react.default.createElement(_report_listing_default.ReportListingDefault, (0, _extends2.default)({}, props, {
    apiClient: apiClient,
    capabilities: capabilities
  }));
};
exports.ReportListing = ReportListing;