"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDiagnostic = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var statuses = /*#__PURE__*/function (statuses) {
  statuses["chromeStatus"] = "chromeStatus";
  statuses["screenshotStatus"] = "screenshotStatus";
  return statuses;
}(statuses || {});
const initialState = {
  [statuses.chromeStatus]: 'incomplete',
  isFlyoutVisible: false,
  help: [],
  logs: '',
  isBusy: false,
  success: true
};
const ReportDiagnostic = ({
  apiClient,
  clientConfig
}) => {
  const [state, setStateBase] = (0, _react.useState)(initialState);
  const setState = s => setStateBase({
    ...state,
    ...s
  });
  const {
    isBusy,
    chromeStatus,
    isFlyoutVisible
  } = state;
  const configAllowsImageReports = clientConfig.export_types.pdf.enabled || clientConfig.export_types.png.enabled;
  const closeFlyout = () => setState({
    ...initialState,
    isFlyoutVisible: false
  });
  const showFlyout = () => setState({
    isFlyoutVisible: true
  });
  const apiWrapper = (apiMethod, statusProp) => () => {
    setState({
      isBusy: true,
      [statusProp]: 'incomplete'
    });
    apiMethod().then(response => {
      setState({
        isBusy: false,
        help: response.help,
        logs: response.logs,
        success: response.success,
        [statusProp]: response.success ? 'complete' : 'danger'
      });
    }).catch(error => {
      setState({
        isBusy: false,
        help: [_i18n.i18n.translate('xpack.reporting.listing.diagnosticApiCallFailure', {
          defaultMessage: `There was a problem running the diagnostic: {error}`,
          values: {
            error
          }
        })],
        logs: `${error.message}`,
        success: false,
        [statusProp]: 'danger'
      });
    });
  };
  let flyout;
  if (isFlyoutVisible) {
    let outcomeCallout;
    if (state.success && chromeStatus === 'complete') {
      outcomeCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        id: "xpack.reporting.listing.diagnosticSuccessMessage",
        color: "success",
        title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticSuccessMessage', {
          defaultMessage: 'Everything looks good for reporting to function.'
        })
      });
    } else if (!state.success && chromeStatus === 'complete') {
      outcomeCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        id: "xpack.reporting.listing.diagnosticFailureTitle",
        iconType: "warning",
        color: "danger",
        title: _i18n.i18n.translate('xpack.reporting.listing.diagnosticFailureTitle', {
          defaultMessage: "Something isn't working properly."
        })
      });
    }
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: closeFlyout,
      "aria-labelledby": "reportingHelperTitle",
      size: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticTitle",
      defaultMessage: "Screenshotting Diagnostics"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticDescription",
      defaultMessage: "Run diagnostics to automatically troubleshoot common reporting problems."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      banner: outcomeCallout
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticBrowserTitle",
      defaultMessage: "Check browser"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticBrowserMessage",
      defaultMessage: "Reporting uses a headless browser to generate PDF and PNGs. Validate that the browser can launch successfully."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: isBusy || chromeStatus === 'complete',
      onClick: apiWrapper(() => apiClient.verifyBrowser(), statuses.chromeStatus),
      isLoading: isBusy && chromeStatus === 'incomplete',
      iconType: chromeStatus === 'complete' ? 'check' : undefined
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.listing.diagnosticBrowserButton",
      defaultMessage: "Check browser"
    }))));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, configAllowsImageReports && /*#__PURE__*/_react.default.createElement("div", null, flyout, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "screenshotDiagnosticLink",
    size: "xs",
    flush: "left",
    onClick: showFlyout
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.listing.diagnosticButton",
    defaultMessage: "Run screenshot diagnostics"
  }))));
};
exports.ReportDiagnostic = ReportDiagnostic;