"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportingNotifierStreamHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _i18n = require("@kbn/i18n");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingPublic = require("@kbn/reporting-public");
var _notifier = require("../notifier");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @todo Replace with `Infinity` once elastic/eui#5945 is resolved.
 * @see https://github.com/elastic/eui/issues/5945
 */
const COMPLETED_JOB_TOAST_TIMEOUT = 24 * 60 * 60 * 1000; // 24 hours

function getReportStatus(src) {
  var _src$prettyJobTypeNam;
  return {
    id: src.id,
    status: src.status,
    title: src.title,
    jobtype: (_src$prettyJobTypeNam = src.prettyJobTypeName) !== null && _src$prettyJobTypeNam !== void 0 ? _src$prettyJobTypeNam : src.jobtype,
    maxSizeReached: src.max_size_reached,
    csvContainsFormulas: src.csv_contains_formulas,
    errorCode: src.error_code
  };
}
function handleError(err, notifications, theme) {
  notifications.toasts.addDanger((0, _notifier.getGeneralErrorToast)(_i18n.i18n.translate('xpack.reporting.publicNotifier.pollingErrorMessage', {
    defaultMessage: 'Reporting notifier error!'
  }), err, theme));
  window.console.error(err);
  return Rx.of({
    completed: [],
    failed: []
  });
}
class ReportingNotifierStreamHandler {
  constructor(notifications, apiClient, theme, docLinks) {
    (0, _defineProperty2.default)(this, "jobCompletionNotifications", (0, _reportingPublic.jobCompletionNotifications)());
    this.notifications = notifications;
    this.apiClient = apiClient;
    this.theme = theme;
    this.docLinks = docLinks;
  }
  startPolling(interval, stop$) {
    Rx.timer(0, interval).pipe((0, _rxjs.takeUntil)(stop$),
    // stop the interval when stop method is called
    (0, _rxjs.map)(this.jobCompletionNotifications.getPendingJobIds),
    // read all pending job IDs from session storage
    (0, _rxjs.filter)(previousPending => previousPending.length > 0),
    // stop the pipeline here if there are none pending
    (0, _rxjs.mergeMap)(previousPending => this.findChangedStatusJobs(previousPending)),
    // look up the latest status of all pending jobs on the server
    (0, _rxjs.mergeMap)(({
      completed,
      failed
    }) => this.showNotifications({
      completed,
      failed
    })), (0, _rxjs.catchError)(err => {
      // eslint-disable-next-line no-console
      console.error(err);
      return handleError(err, this.notifications, this.theme);
    })).subscribe();
  }

  /*
   * Use Kibana Toast API to show our messages
   */
  showNotifications({
    completed: completedJobs,
    failed: failedJobs
  }) {
    const notifications = this.notifications;
    const apiClient = this.apiClient;
    const theme = this.theme;
    const docLinks = this.docLinks;
    const getManagementLink = apiClient.getManagementLink.bind(apiClient);
    const getDownloadLink = apiClient.getDownloadLink.bind(apiClient);
    const showNotificationsAsync = async () => {
      const completedOptions = {
        toastLifeTimeMs: COMPLETED_JOB_TOAST_TIMEOUT
      };

      // notifications with download link
      for (const job of completedJobs !== null && completedJobs !== void 0 ? completedJobs : []) {
        if (job.csvContainsFormulas) {
          notifications.toasts.addWarning((0, _notifier.getWarningFormulasToast)(job, getManagementLink, getDownloadLink, theme), completedOptions);
        } else if (job.maxSizeReached) {
          notifications.toasts.addWarning((0, _notifier.getWarningMaxSizeToast)(job, getManagementLink, getDownloadLink, theme), completedOptions);
        } else if (job.status === _reportingCommon.JOB_STATUS.WARNINGS) {
          notifications.toasts.addWarning((0, _notifier.getWarningToast)(job, getManagementLink, getDownloadLink, theme), completedOptions);
        } else {
          notifications.toasts.addSuccess((0, _notifier.getSuccessToast)(job, getManagementLink, getDownloadLink, theme), completedOptions);
        }
      }

      // no download link available
      for (const job of failedJobs !== null && failedJobs !== void 0 ? failedJobs : []) {
        const errorText = await apiClient.getError(job.id);
        this.notifications.toasts.addDanger((0, _notifier.getFailureToast)(errorText, job, getManagementLink, theme, docLinks));
      }
      return {
        completed: completedJobs,
        failed: failedJobs
      };
    };
    return Rx.from(showNotificationsAsync()); // convert Promise to Observable, for the convenience of the main stream
  }

  /*
   * An observable that finds jobs that are known to be "processing" (stored in
   * session storage) but have non-processing job status on the server
   */
  findChangedStatusJobs(previousPending) {
    return Rx.from(this.apiClient.findForJobIds(previousPending)).pipe((0, _rxjs.mergeMap)(async jobs => {
      const newCompleted = [];
      const newFailed = [];
      const newPending = [];
      for (const pendingJobId of previousPending) {
        const updatedJob = jobs.find(({
          id
        }) => id === pendingJobId);
        if ((updatedJob === null || updatedJob === void 0 ? void 0 : updatedJob.status) === _reportingCommon.JOB_STATUS.COMPLETED || (updatedJob === null || updatedJob === void 0 ? void 0 : updatedJob.status) === _reportingCommon.JOB_STATUS.WARNINGS) {
          newCompleted.push(getReportStatus(updatedJob));
        } else if ((updatedJob === null || updatedJob === void 0 ? void 0 : updatedJob.status) === _reportingCommon.JOB_STATUS.FAILED) {
          newFailed.push(getReportStatus(updatedJob));
        } else {
          // Keep job tracked in storage if is pending. It also
          // may not be present in apiClient.findForJobIds
          // response if index refresh is slow
          newPending.push(pendingJobId);
        }
      }

      // refresh the storage of pending job IDs, minus
      // the newly completed and failed jobs
      this.jobCompletionNotifications.setPendingJobIds(newPending);
      return {
        completed: newCompleted,
        failed: newFailed
      };
    }), (0, _rxjs.catchError)(err => {
      // show connection refused toast
      this.notifications.toasts.addDanger((0, _notifier.getGeneralErrorToast)(_i18n.i18n.translate('xpack.reporting.publicNotifier.httpErrorMessage', {
        defaultMessage: 'Could not check Reporting job status!'
      }), err, this.theme));
      window.console.error(err);
      return Rx.of({});
    }));
  }
}
exports.ReportingNotifierStreamHandler = ReportingNotifierStreamHandler;