"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PdfExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _reportingCommon = require("@kbn/reporting-common");
var _reportingServer = require("@kbn/reporting-server");
var _reportingExportTypesPdfCommon = require("@kbn/reporting-export-types-pdf-common");
var _get_custom_logo = require("./get_custom_logo");
var _pdf_tracker = require("./pdf_tracker");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PdfExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesPdfCommon.PDF_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "name", 'PDF');
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesPdfCommon.PDF_JOB_TYPE_V2);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'pdf');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    /**
     * @param JobParamsPDFV2
     * @returns jobParams
     */
    (0, _defineProperty2.default)(this, "createJob", async ({
      locatorParams,
      ...jobParams
    }) => {
      return {
        ...jobParams,
        locatorParams,
        isDeprecated: false,
        browserTimezone: jobParams.browserTimezone,
        forceNow: new Date().toISOString()
      };
    });
    /**
     *
     * @param jobId
     * @param payload
     * @param cancellationToken
     * @param stream
     */
    (0, _defineProperty2.default)(this, "runTask", (jobId, payload, taskInstanceFields, cancellationToken, stream) => {
      const logger = this.logger.get(`execute-job:${jobId}`);
      const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf-v2', _reportingServer.REPORTING_TRANSACTION_TYPE);
      const apmGetAssets = apmTrans.startSpan('get-assets', 'setup');
      let apmGeneratePdf;
      const {
        encryptionKey
      } = this.config;
      const process$ = (0, _rxjs.of)(1).pipe((0, _rxjs.mergeMap)(() => (0, _reportingServer.decryptJobHeaders)(encryptionKey, payload.headers, logger)), (0, _rxjs.mergeMap)(async headers => {
        const fakeRequest = this.getFakeRequest(headers, payload.spaceId, logger);
        const uiSettingsClient = await this.getUiSettingsClient(fakeRequest);
        return await (0, _get_custom_logo.getCustomLogo)(uiSettingsClient, headers);
      }), (0, _rxjs.mergeMap)(({
        logo,
        headers
      }) => {
        const {
          browserTimezone,
          layout,
          title,
          locatorParams
        } = payload;
        apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
        apmGeneratePdf = apmTrans.startSpan('generate-pdf-pipeline', 'execute');
        const tracker = (0, _pdf_tracker.getTracker)();
        tracker.startScreenshots();

        /**
         * For each locator we get the relative URL to the redirect app
         */
        const urls = locatorParams.map(locator => [(0, _reportingServer.getFullRedirectAppUrl)(this.config, this.getServerInfo(), payload.spaceId, payload.forceNow), locator]);
        return this.startDeps.screenshotting.getScreenshots({
          format: 'pdf',
          title,
          logo,
          browserTimezone,
          headers,
          layout,
          urls: urls.map(url => typeof url === 'string' ? url : [url[0], {
            [_reportingCommon.REPORTING_REDIRECT_LOCATOR_STORE_KEY]: url[1]
          }]),
          taskInstanceFields,
          logger
        }).pipe((0, _rxjs.tap)(({
          metrics
        }) => {
          if (metrics.cpu) {
            tracker.setCpuUsage(metrics.cpu);
          }
          if (metrics.memory) {
            tracker.setMemoryUsage(metrics.memory);
          }
        }), (0, _rxjs.mergeMap)(async ({
          data: buffer,
          errors,
          metrics,
          renderErrors
        }) => {
          tracker.endScreenshots();
          const warnings = [];
          if (errors) {
            warnings.push(...errors.map(error => error.message));
          }
          if (renderErrors) {
            warnings.push(...renderErrors);
          }
          return {
            buffer,
            metrics,
            warnings
          };
        }));
      }), (0, _rxjs.tap)(({
        buffer
      }) => {
        var _apmGeneratePdf;
        (_apmGeneratePdf = apmGeneratePdf) === null || _apmGeneratePdf === void 0 ? void 0 : _apmGeneratePdf.end();
        if (buffer) {
          stream.write(buffer);
        }
      }), (0, _rxjs.map)(({
        metrics,
        warnings
      }) => ({
        content_type: 'application/pdf',
        metrics: {
          pdf: metrics
        },
        warnings
      })), (0, _rxjs.catchError)(err => {
        logger.error(err);
        return Rx.throwError(() => err);
      }));
      const stop$ = Rx.fromEventPattern(cancellationToken.on);
      apmTrans.end();
      return Rx.firstValueFrom(process$.pipe((0, _rxjs.takeUntil)(stop$)));
    });
    this.logger = this.logger.get('pdf-export-v2');
  }
}
exports.PdfExportType = PdfExportType;