"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterList = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
var _remote_cluster_list = require("./remote_cluster_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    clusters: (0, _selectors.getClustersList)(state),
    isDetailPanelOpen: (0, _selectors.isDetailPanelOpen)(state),
    isLoading: (0, _selectors.isLoading)(state),
    isCopyingCluster: (0, _selectors.isEditingCluster)(state),
    isRemovingCluster: (0, _selectors.isRemovingCluster)(state),
    clusterLoadError: (0, _selectors.clusterLoadError)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    loadClusters: () => {
      dispatch((0, _actions.loadClusters)());
    },
    refreshClusters: () => {
      dispatch((0, _actions.refreshClusters)());
    },
    openDetailPanel: name => {
      dispatch((0, _actions.openDetailPanel)({
        name
      }));
    },
    closeDetailPanel: () => {
      dispatch((0, _actions.closeDetailPanel)());
    }
  };
};
const RemoteClusterList = exports.RemoteClusterList = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_remote_cluster_list.RemoteClusterList);