"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoveClusterButtonProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RemoveClusterButtonProvider extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "showConfirmModal", () => {
      this.setState({
        isModalOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      const {
        removeClusters,
        clusterNames
      } = this.props;
      removeClusters(clusterNames);
      this.closeConfirmModal();
    });
  }
  render() {
    const {
      clusterNames,
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    const isSingleCluster = clusterNames.length === 1;
    let modal;
    if (isModalOpen) {
      const title = isSingleCluster ? _i18n.i18n.translate('xpack.remoteClusters.removeButton.confirmModal.deleteSingleClusterTitle', {
        defaultMessage: "Remove remote cluster '{name}'?",
        values: {
          name: clusterNames[0]
        }
      }) : _i18n.i18n.translate('xpack.remoteClusters.removeButton.confirmModal.multipleDeletionTitle', {
        defaultMessage: 'Remove {count} remote clusters?',
        values: {
          count: clusterNames.length
        }
      });
      const content = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.removeButton.confirmModal.multipleDeletionDescription",
        defaultMessage: "You are about to remove these remote clusters:"
      })), /*#__PURE__*/_react.default.createElement("ul", null, clusterNames.map(name => /*#__PURE__*/_react.default.createElement("li", {
        key: name
      }, name))));
      modal = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "data-test-subj": "remoteClustersDeleteConfirmModal",
        title: title,
        onCancel: this.closeConfirmModal,
        onConfirm: this.onConfirm,
        cancelButtonText: _i18n.i18n.translate('xpack.remoteClusters.removeButton.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        buttonColor: "danger",
        confirmButtonText: _i18n.i18n.translate('xpack.remoteClusters.removeButton.confirmModal.confirmButtonText', {
          defaultMessage: 'Remove'
        }),
        onMouseOver: this.onMouseOverModal
      }, !isSingleCluster && content));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(this.showConfirmModal), modal);
  }
}
exports.RemoveClusterButtonProvider = RemoveClusterButtonProvider;
(0, _defineProperty2.default)(RemoveClusterButtonProvider, "propTypes", {
  removeClusters: _propTypes.default.func.isRequired,
  clusterNames: _propTypes.default.array.isRequired,
  children: _propTypes.default.func.isRequired
});